/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot.rule;

import com.mmyzd.nmsot.SpawnListManager;
import com.mmyzd.nmsot.SpawningEntry;
import com.mmyzd.nmsot.rule.Rule;
import com.mmyzd.nmsot.rule.RuleAnd;
import com.mmyzd.nmsot.rule.RuleBiome;
import com.mmyzd.nmsot.rule.RuleBiomeType;
import com.mmyzd.nmsot.rule.RuleBlock;
import com.mmyzd.nmsot.rule.RuleChance;
import com.mmyzd.nmsot.rule.RuleDimension;
import com.mmyzd.nmsot.rule.RuleMaterial;
import com.mmyzd.nmsot.rule.RuleMob;
import com.mmyzd.nmsot.rule.RuleMobType;
import com.mmyzd.nmsot.rule.RuleNot;
import com.mmyzd.nmsot.rule.RuleOr;
import com.mmyzd.nmsot.rule.RulePosition;
import com.mmyzd.nmsot.rule.RuleWood;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;

public class RuleSet
extends Rule {
    public Rule[] rule;
    public boolean[] black;

    public RuleSet(String[] data) {
        int i;
        int n = data.length;
        ArrayList<Rule> u = new ArrayList<Rule>();
        ArrayList<Boolean> v = new ArrayList<Boolean>();
        for (i = 0; i < n; ++i) {
            LogManager.getLogger((String)"nmsot").info("Now parsing " + data[i] + "");
            boolean flip = false;
            int m = data[i].length();
            LinkedList<Character> s = new LinkedList<Character>();
            for (int j = 0; j < m; ++j) {
                s.add(Character.valueOf(data[i].charAt(j)));
            }
            s.add(Character.valueOf('#'));
            char c = RuleSet.skipSpace(s);
            if (c == '-') {
                flip = true;
            }
            if (c == '-' || c == '+' || c == '@') {
                s.removeFirst();
            }
            if (c == '#') continue;
            try {
                if (c == '@') {
                    SpawnListManager.parse(s);
                    continue;
                }
                Rule rule = this.expr(s);
                if (RuleSet.skipSpace(s) != '#') {
                    throw new Exception("Syntax error");
                }
                u.add(rule);
                v.add(flip);
                continue;
            }
            catch (Exception e) {
                StringBuilder debugInfo = new StringBuilder();
                int space = data[i].length() - s.size() + 1;
                while (space-- > 0) {
                    debugInfo.append(' ');
                }
                while (!s.isEmpty()) {
                    debugInfo.append(s.getFirst());
                    s.removeFirst();
                }
                LogManager.getLogger((String)"nmsot").warn("  Failed at " + debugInfo.toString());
                LogManager.getLogger((String)"nmsot").warn("  Caused by " + e.toString());
            }
        }
        n = u.size();
        this.rule = new Rule[n];
        this.black = new boolean[n];
        for (i = 0; i < n; ++i) {
            this.rule[i] = (Rule)u.get(i);
            this.black[i] = (Boolean)v.get(i) == false;
        }
    }

    public static char skipSpace(LinkedList<Character> s) {
        while (Character.isWhitespace(s.getFirst().charValue())) {
            s.removeFirst();
        }
        return s.getFirst().charValue();
    }

    public static boolean isDelimiter(char c) {
        return Character.isWhitespace(c) || ":#()!~|&,".indexOf(c) != -1;
    }

    public static boolean getTokenEqualsIgnoreCase(LinkedList<Character> s, String target) {
        target = target.toLowerCase();
        if (RuleSet.isDelimiter(RuleSet.skipSpace(s))) {
            if (target.length() == 1 && target.charAt(0) == s.getFirst().charValue()) {
                s.removeFirst();
                return true;
            }
            return false;
        }
        int n = target.length();
        for (int i = 0; i <= n; ++i) {
            char c = Character.toLowerCase(s.getFirst().charValue());
            if (i == n && !RuleSet.isDelimiter(c) || i != n && c != target.charAt(i)) {
                while (i > 0) {
                    s.addFirst(Character.valueOf(target.charAt(--i)));
                }
                return false;
            }
            if (i == n) continue;
            s.removeFirst();
        }
        return true;
    }

    public static String getToken(LinkedList<Character> s) {
        StringBuilder u = new StringBuilder();
        char c = RuleSet.skipSpace(s);
        u.append(c);
        s.removeFirst();
        if (RuleSet.isDelimiter(c)) {
            return u.toString();
        }
        while (!RuleSet.isDelimiter(c = s.getFirst().charValue())) {
            u.append(c);
            s.removeFirst();
        }
        return u.toString();
    }

    public static void nextPart(LinkedList<Character> s) throws Exception {
        if (!RuleSet.getTokenEqualsIgnoreCase(s, ":")) {
            throw new Exception("Syntax error, \":\" is required");
        }
    }

    Rule expr(LinkedList<Character> s) throws Exception {
        ArrayList<Rule> list = new ArrayList<Rule>();
        list.add(this.term(s));
        char o = '|';
        while (RuleSet.skipSpace(s) == o) {
            s.removeFirst();
            if (s.getFirst().charValue() == o) {
                s.removeFirst();
            }
            list.add(this.term(s));
        }
        if (list.size() == 0) {
            throw new Exception("Empty expression");
        }
        if (list.size() == 1) {
            return (Rule)list.get(0);
        }
        return new RuleOr(list);
    }

    Rule term(LinkedList<Character> s) throws Exception {
        ArrayList<Rule> list = new ArrayList<Rule>();
        list.add(this.factor(s));
        char o = '&';
        while (RuleSet.skipSpace(s) == o) {
            s.removeFirst();
            if (s.getFirst().charValue() == o) {
                s.removeFirst();
            }
            list.add(this.factor(s));
        }
        if (list.size() == 0) {
            throw new Exception("Empty expression");
        }
        if (list.size() == 1) {
            return (Rule)list.get(0);
        }
        return new RuleAnd(list);
    }

    Rule factor(LinkedList<Character> s) throws Exception {
        boolean not = false;
        while ("!~".indexOf(RuleSet.skipSpace(s)) != -1) {
            not = !not;
            s.removeFirst();
        }
        Rule rule = null;
        if (RuleSet.getTokenEqualsIgnoreCase(s, "(")) {
            rule = this.expr(s);
            if (!RuleSet.getTokenEqualsIgnoreCase(s, ")")) {
                throw new Exception("Unmatched parentheses");
            }
        } else {
            if (RuleSet.getTokenEqualsIgnoreCase(s, "woodlogs")) {
                rule = new RuleWood();
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "block")) {
                rule = new RuleBlock(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "position")) {
                rule = new RulePosition(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "material")) {
                rule = new RuleMaterial(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "mob")) {
                rule = new RuleMob(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "mobtype")) {
                rule = new RuleMobType(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "dim")) {
                rule = new RuleDimension(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "chance")) {
                rule = new RuleChance(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "biome")) {
                rule = new RuleBiome(s);
            }
            if (RuleSet.getTokenEqualsIgnoreCase(s, "biometype")) {
                rule = new RuleBiomeType(s);
            }
        }
        if (rule == null) {
            throw new Exception("Invalid tag <" + RuleSet.getToken(s) + ">");
        }
        if (rule instanceof RuleNot && not) {
            return ((RuleNot)rule).rule;
        }
        if (not) {
            return new RuleNot(rule);
        }
        return rule;
    }

    @Override
    public boolean apply(SpawningEntry entry) {
        boolean result = false;
        int n = this.rule.length;
        for (int i = 0; i < n; ++i) {
            if (!this.rule[i].apply(entry)) continue;
            result = this.black[i];
        }
        return result;
    }
}

