/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import com.github.lunatrius.stackie.reference.Names;
import java.io.File;
import java.util.regex.Pattern;
import net.minecraft.init.Items;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ConfigurationHandler {
    public static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    public static final int STACK_LIMIT_MIN = 100;
    public static final int STACK_LIMIT_MAX = 10000;
    public static final int INTERVAL_MIN = 5;
    public static final int INTERVAL_MAX = 1200;
    public static final double DISTANCE_MIN = 0.01;
    public static final double DISTANCE_MAX = 10.0;
    public static final int MAXIMUM_STACK_SIZE_MIN = 64;
    public static final int MAXIMUM_STACK_SIZE_MAX = 127;
    public static final int MAXIMUM_EXPERIENCE_MIN = 32;
    public static final int MAXIMUM_EXPERIENCE_MAX = 16384;
    public static Configuration configuration;
    public static final int STACK_LIMIT_DEFAULT = 2000;
    public static final int INTERVAL_DEFAULT = 20;
    public static final double DISTANCE_DEFAULT = 0.75;
    public static final boolean STACK_ITEMS_DEFAULT = false;
    public static final boolean STACK_EXPERIENCE_DEFAULT = true;
    public static final String[] STACK_SIZES_DEFAULT;
    public static final int MAXIMUM_STACK_SIZE_DEFAULT = 64;
    public static final int MAXIMUM_EXPERIENCE_DEFAULT = 1024;
    public static int stackLimit;
    public static int interval;
    public static double distance;
    public static boolean stackItems;
    public static boolean stackExperience;
    public static String[] stackSizes;
    public static int maximumStackSize;
    public static int maximumExperience;
    public static Property propStackLimit;
    public static Property propInterval;
    public static Property propDistance;
    public static Property propStackItems;
    public static Property propStackExperience;
    public static Property propStackSizes;
    public static Property propMaximumStackSize;
    public static Property propMaximumExperience;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        propStackLimit = configuration.get("general", "stackLimit", 2000, "If the amount of entities surpasses this number stacking will be disabled (per dimension).", 100, 10000);
        propStackLimit.setLanguageKey(Names.Config.LANG_PREFIX + "." + "stackLimit");
        stackLimit = propStackLimit.getInt(2000);
        propInterval = configuration.get("general", "interval", 20, "Amount of ticks (20 ticks => 1 second) that will pass between each stacking attempt.", 5, 1200);
        propInterval.setLanguageKey(Names.Config.LANG_PREFIX + "." + "interval");
        interval = propInterval.getInt(20);
        propDistance = configuration.get("general", "distance", 0.75, "Maximum distance between items/experience orbs that can be still stacked (relative to block size).", 0.01, 10.0);
        propDistance.setLanguageKey(Names.Config.LANG_PREFIX + "." + "distance");
        distance = propDistance.getDouble(0.75);
        propStackItems = configuration.get("general", "stackItems", false, "Should it stack items?");
        propStackItems.setLanguageKey(Names.Config.LANG_PREFIX + "." + "stackItems");
        stackItems = propStackItems.getBoolean(false);
        propStackExperience = configuration.get("general", "stackExperience", true, "Should it stack experience orbs?");
        propStackExperience.setLanguageKey(Names.Config.LANG_PREFIX + "." + "stackExperience");
        stackExperience = propStackExperience.getBoolean(true);
        propStackSizes = configuration.get("general", "stackSizes", STACK_SIZES_DEFAULT, "A list of uniqueName-stackSize mappings. These values will override the default stack sizes.");
        propStackSizes.setLanguageKey(Names.Config.LANG_PREFIX + "." + "stackSizes");
        propStackSizes.setValidationPattern(Pattern.compile("[A-Za-z0-9_:]+-\\d+"));
        stackSizes = propStackSizes.getStringList();
        propMaximumStackSize = configuration.get("general", "maximumStackSize", 64, "Items will be stacked up to this amount.", 64, 127);
        propMaximumStackSize.setLanguageKey(Names.Config.LANG_PREFIX + "." + "maximumStackSize");
        maximumStackSize = propMaximumStackSize.getInt(64);
        propMaximumExperience = configuration.get("general", "maximumExperience", 1024, "Experience will be stacked up to this amount.", 32, 16384);
        propMaximumExperience.setLanguageKey(Names.Config.LANG_PREFIX + "." + "maximumExperience");
        maximumExperience = propMaximumExperience.getInt(1024);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setStackLimit(int num) {
        propStackLimit.set(num < 100 ? 100 : (num > 10000 ? 10000 : num));
        stackLimit = propStackLimit.getInt(num);
    }

    public static void setInterval(int num) {
        propInterval.set(num < 5 ? 5 : (num > 1200 ? 1200 : num));
        interval = propInterval.getInt(num);
    }

    public static void setDistance(double num) {
        propDistance.set(num < 0.01 ? 0.01 : (num > 10.0 ? 10.0 : num));
        distance = propDistance.getDouble(num);
    }

    public static void setStackItems(boolean stack) {
        propStackItems.set(stack);
        stackItems = propStackItems.getBoolean(stack);
    }

    public static void setStackExperience(boolean stack) {
        propStackExperience.set(stack);
        stackExperience = propStackExperience.getBoolean(stack);
    }

    public static void save() {
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private ConfigurationHandler() {
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("Stackie")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    static {
        STACK_SIZES_DEFAULT = new String[]{GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151143_au) + "-" + 4, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151141_av) + "-" + 8, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151139_aw) + "-" + 64, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151124_az) + "-" + 4, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151108_aI) + "-" + 4, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151109_aJ) + "-" + 4, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151142_bV) + "-" + 4, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151140_bW) + "-" + 4, GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)Items.field_151095_cc) + "-" + 4};
        stackLimit = 2000;
        interval = 20;
        distance = 0.75;
        stackItems = false;
        stackExperience = true;
        stackSizes = STACK_SIZES_DEFAULT;
        maximumStackSize = 64;
        maximumExperience = 1024;
        propStackLimit = null;
        propInterval = null;
        propDistance = null;
        propStackItems = null;
        propStackExperience = null;
        propStackSizes = null;
        propMaximumStackSize = null;
        propMaximumExperience = null;
    }
}

