/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LeafDecayHelper {
    private static final byte SUSTAINS_LEAVES = 0;
    private static final byte NOT_SUSTAINS_LEAVES = -1;
    private static final byte IS_LEAVES = -2;
    private static final int ARRAY_SIZE = 32;
    private static final byte[][][] leafDecayValues = new byte[32][32][32];

    public static void leafDecay(BlockLeaves leaves, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            byte sustainValue;
            int radius = 4;
            int arrayOffset = 16;
            if (world.func_175697_a(pos, radius + 1)) {
                for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
                    for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                        for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                            BlockPos blockPos = pos.func_177982_a(xOffset, yOffset, zOffset);
                            IBlockState blockState = world.func_180495_p(blockPos);
                            Block block = blockState.func_177230_c();
                            if (!block.canSustainLeaves(blockState, (IBlockAccess)world, blockPos)) {
                                if (block.isLeaves(blockState, (IBlockAccess)world, blockPos)) {
                                    LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset] = -2;
                                    continue;
                                }
                                LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset] = -1;
                                continue;
                            }
                            LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset] = 0;
                        }
                    }
                }
                for (int sustainedValue = 1; sustainedValue <= 8; sustainedValue = (int)((byte)(sustainedValue + 1))) {
                    for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
                        for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                                if (leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset] != sustainedValue - 1) continue;
                                if (leafDecayValues[xOffset + arrayOffset - 1][yOffset + arrayOffset][zOffset + arrayOffset] == -2) {
                                    LeafDecayHelper.leafDecayValues[xOffset + arrayOffset - 1][yOffset + arrayOffset][zOffset + arrayOffset] = sustainedValue;
                                }
                                if (leafDecayValues[xOffset + arrayOffset + 1][yOffset + arrayOffset][zOffset + arrayOffset] == -2) {
                                    LeafDecayHelper.leafDecayValues[xOffset + arrayOffset + 1][yOffset + arrayOffset][zOffset + arrayOffset] = sustainedValue;
                                }
                                if (leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset - 1][zOffset + arrayOffset] == -2) {
                                    LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset - 1][zOffset + arrayOffset] = sustainedValue;
                                }
                                if (leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset + 1][zOffset + arrayOffset] == -2) {
                                    LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset + 1][zOffset + arrayOffset] = sustainedValue;
                                }
                                if (leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset - 1] == -2) {
                                    LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset - 1] = sustainedValue;
                                }
                                if (leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset + 1] != -2) continue;
                                LeafDecayHelper.leafDecayValues[xOffset + arrayOffset][yOffset + arrayOffset][zOffset + arrayOffset + 1] = sustainedValue;
                            }
                        }
                    }
                }
            }
            if ((sustainValue = leafDecayValues[arrayOffset][arrayOffset][arrayOffset]) >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                leaves.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
            }
        }
    }
}

