/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.fence;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.fence.BlockForestryFence;
import forestry.arboriculture.blocks.property.PropertyForestryWoodType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockArbFence
extends BlockForestryFence<EnumForestryWoodType>
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    public static List<BlockArbFence> create(boolean fireproof) {
        ArrayList<BlockArbFence> blocks = new ArrayList<BlockArbFence>();
        PropertyForestryWoodType[] variants = PropertyForestryWoodType.create("variant", 16);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyForestryWoodType variant = variants[i];
            BlockArbFence block = new BlockArbFence(fireproof, i){

                @Nonnull
                public PropertyForestryWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockArbFence(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
    }

    @Override
    @Nonnull
    public EnumForestryWoodType getWoodType(int meta) {
        int variantMeta = (meta & 0xF) + this.getBlockNumber() * 16;
        return EnumForestryWoodType.byMetadata(variantMeta);
    }
}

