/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.log;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.arboriculture.blocks.log.BlockForestryLog;
import forestry.arboriculture.blocks.property.PropertyForestryWoodType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockArbLog
extends BlockForestryLog<EnumForestryWoodType> {
    public static List<BlockArbLog> create(boolean fireproof) {
        ArrayList<BlockArbLog> blocks = new ArrayList<BlockArbLog>();
        PropertyForestryWoodType[] variants = PropertyForestryWoodType.create("variant", 4);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyForestryWoodType variant = variants[i];
            BlockArbLog block = new BlockArbLog(fireproof, i){

                @Nonnull
                public PropertyForestryWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockArbLog(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
    }

    @Override
    @Nonnull
    public EnumForestryWoodType getWoodType(int meta) {
        int variantMeta = (meta & 3) + this.getBlockNumber() * 4;
        return EnumForestryWoodType.byMetadata(variantMeta);
    }
}

