/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenMaple
extends WorldGenTree {
    public WorldGenMaple(ITreeGenData tree) {
        super(tree, 7, 5);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        for (int yBranch = 2; yBranch < this.height - 2; ++yBranch) {
            branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, yBranch, 0), this.girth, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.25f), 1, 0.25f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 2 + this.girth, 2, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        float diameterchange = 1.0f / (float)this.height;
        int leafSpawned = 2;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        while (leafSpawn > 1) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f * diameterchange * (float)leafSpawned + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.0f * diameterchange * (float)leafSpawned + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
            leafSpawned += 2;
        }
    }
}

