/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.CommandHelpers;
import forestry.core.commands.IForestryCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class SubCommand
implements IForestryCommand {
    private final String name;
    private final List<String> aliases = new ArrayList<String>();
    private PermLevel permLevel = PermLevel.EVERYONE;
    private IForestryCommand parent;
    private final SortedSet<SubCommand> children = new TreeSet<SubCommand>();

    public SubCommand(String name) {
        this.name = name;
    }

    public final String func_71517_b() {
        return this.name;
    }

    public SubCommand addChildCommand(SubCommand child) {
        child.setParent(this);
        this.children.add(child);
        return this;
    }

    void setParent(IForestryCommand parent) {
        this.parent = parent;
    }

    @Override
    public SortedSet<SubCommand> getChildren() {
        return this.children;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    @Override
    public List<String> func_71514_a() {
        return this.aliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return CommandHelpers.addStandardTabCompletionOptions(server, this, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!CommandHelpers.processStandardCommands(server, sender, this, args)) {
            this.executeSubCommand(server, sender, args);
        }
    }

    public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException, CommandException {
        this.printHelp(sender);
    }

    public SubCommand setPermLevel(PermLevel permLevel) {
        this.permLevel = permLevel;
        return this;
    }

    @Override
    public final int getPermissionLevel() {
        return this.permLevel.permLevel;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(this.getPermissionLevel(), this.func_71517_b());
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.getFullCommandString() + " help";
    }

    @Override
    public void printHelp(ICommandSender sender) {
        CommandHelpers.printHelp(sender, this);
    }

    @Override
    public String getFullCommandString() {
        return this.parent.getFullCommandString() + " " + this.func_71517_b();
    }

    public int compareTo(@Nonnull ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }

    public static enum PermLevel {
        EVERYONE(0),
        ADMIN(2);

        public final int permLevel;

        private PermLevel(int permLevel) {
            this.permLevel = permLevel;
        }
    }
}

