/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.core.render.TextureManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumErrorCode implements IErrorState
{
    TOO_HOT("tooHot"),
    TOO_COLD("tooCold"),
    TOO_HUMID("tooHumid"),
    TOO_ARID("tooArid", "invalidBiome"),
    IS_RAINING("isRaining"),
    NOT_GLOOMY("notGloomy"),
    NOT_BRIGHT("notLucid"),
    NOT_DAY("notDay"),
    NOT_NIGHT("notNight"),
    NO_FLOWER("noFlower"),
    NO_QUEEN("noQueen"),
    NO_DRONE("noDrone"),
    NO_SKY("noSky"),
    NO_RESOURCE("noResource"),
    NO_RESOURCE_INVENTORY("noResourceInventory", "noResource"),
    NO_RESOURCE_LIQUID("noResourceLiquid", "noLiquid"),
    NO_RECIPE("noRecipe"),
    NO_SPACE_INVENTORY("noSpace"),
    NO_SPACE_TANK("noSpaceTank"),
    NO_POWER("noPower"),
    NO_REDSTONE("noRedstone", "disabled"),
    DISABLED_BY_REDSTONE("disabledRedstone", "disabled"),
    NOT_DARK("notDark", "notGloomy"),
    NOT_RAINING("notRaining"),
    NO_RAIN_BIOME("noRainBiome", "notRaining"),
    NO_SKY_RAIN_TANK("noSkyRainTank", "noSky"),
    NO_HONEY("noHoney"),
    NO_SPECIMEN("noSpecimen"),
    FORCED_COOLDOWN("forcedCooldown"),
    NO_FUEL("noFuel"),
    NO_HEAT("noHeat"),
    NO_ENERGY_NET("noEnergyNet"),
    NO_STAMPS("noStamps"),
    NO_PAPER("noPaper"),
    NO_SUPPLIES("noSupplies", "noResource"),
    NO_TRADE("noTrade", "noResource"),
    NOT_ALPHANUMERIC("notAlphaNumeric"),
    NOT_UNIQUE("notUnique"),
    NOT_POST_PAID("notPostpaid", "noStamps"),
    NO_RECIPIENT("noRecipient"),
    NO_CIRCUIT_BOARD("noCircuitBoard"),
    NO_CIRCUIT_LAYOUT("noCircuitLayout"),
    CIRCUIT_MISMATCH("circuitMismatch"),
    NO_FERTILIZER("noFertilizer"),
    NO_FARMLAND("noFarmland"),
    NO_LIQUID_FARM("noLiquid");

    private final String name;
    private final String iconName;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite texture;

    private EnumErrorCode(String name) {
        this(name, name);
    }

    private EnumErrorCode(String name, String iconName) {
        this.name = name;
        this.iconName = iconName;
    }

    @Override
    public String getUnlocalizedDescription() {
        return "for.errors." + this.name + ".desc";
    }

    @Override
    public String getUnlocalizedHelp() {
        return "for.errors." + this.name + ".help";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprite() {
        this.texture = TextureManager.registerSprite(new ResourceLocation("forestry", "gui/errors/" + this.iconName));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return this.texture;
    }

    @Override
    public short getID() {
        return (short)this.ordinal();
    }

    @Override
    public String getUniqueName() {
        return "forestry:" + this.name;
    }

    public static void init() {
        for (EnumErrorCode code : EnumErrorCode.values()) {
            ForestryAPI.errorStateRegistry.registerErrorState(code);
        }
    }
}

