/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class WidgetManager {
    public final GuiForestry gui;
    public final Minecraft minecraft;
    protected final List<Widget> widgets = new ArrayList<Widget>();

    public WidgetManager(GuiForestry gui) {
        this.gui = gui;
        this.minecraft = Proxies.common.getClientInstance();
    }

    public void add(Widget slot) {
        this.widgets.add(slot);
    }

    public void remove(Widget slot) {
        this.widgets.remove(slot);
    }

    public void clear() {
        this.widgets.clear();
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public Widget getAtPosition(int mX, int mY) {
        for (Widget slot : this.widgets) {
            if (!slot.isMouseOver(mX, mY)) continue;
            return slot;
        }
        return null;
    }

    public void drawWidgets() {
        for (Widget slot : this.widgets) {
            slot.draw(0, 0);
        }
    }

    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        Widget slot = this.getAtPosition(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
        if (slot != null) {
            slot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    public void handleMouseRelease(int mouseX, int mouseY, int eventType) {
        for (Widget slot : this.widgets) {
            slot.handleMouseRelease(mouseX, mouseY, eventType);
        }
    }

    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
        for (Widget slot : this.widgets) {
            slot.handleMouseMove(mouseX, mouseY, mouseButton, time);
        }
    }
}

