/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.IColoredBlock;
import forestry.core.items.IColoredItem;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelEntry;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelManager
implements IModelManager {
    private static final ModelManager instance = new ModelManager();
    private final List<BlockModelEntry> customBlockModels = new ArrayList<BlockModelEntry>();
    private final List<ModelEntry> customModels = new ArrayList<ModelEntry>();
    private final List<IItemModelRegister> itemModelRegisters = new ArrayList<IItemModelRegister>();
    private final List<IStateMapperRegister> stateMapperRegisters = new ArrayList<IStateMapperRegister>();
    private final List<IColoredBlock> blockColorList = new ArrayList<IColoredBlock>();
    private final List<IColoredItem> itemColorList = new ArrayList<IColoredItem>();
    private TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public final IModelState DEFAULT_BLOCK;
    public final IModelState DEFAULT_ITEM;
    public final IModelState DEFAULT_TOOL;

    public ModelManager() {
        TRSRTransformation blockThirdperson = this.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder blockBuilder = ImmutableMap.builder();
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)this.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)this.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)this.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)blockThirdperson);
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)this.leftify(blockThirdperson));
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)this.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        blockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)this.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        this.DEFAULT_BLOCK = new SimpleModelState(blockBuilder.build());
        TRSRTransformation itemThirdperson = this.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstperson = this.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        itemBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)this.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        itemBuilder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)this.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        itemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)itemThirdperson);
        itemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)this.leftify(itemThirdperson));
        itemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
        itemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)this.leftify(firstperson));
        this.DEFAULT_ITEM = new SimpleModelState(itemBuilder.build());
        this.DEFAULT_TOOL = new SimpleModelState(ImmutableMap.of((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)this.get(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f), (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)this.get(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)this.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)this.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f)));
    }

    public static ModelManager getInstance() {
        return instance;
    }

    private TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    private TRSRTransformation leftify(TRSRTransformation transform) {
        if (this.flipX == null) {
            this.flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
        }
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)this.flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(this.flipX));
    }

    @Override
    public void registerItemModel(Item item, int meta, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(identifier));
    }

    @Override
    public void registerItemModel(Item item, int meta, String modID, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(modID, identifier));
    }

    @Override
    public void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(item));
    }

    @Override
    public void registerItemModel(Item item, ItemMeshDefinition definition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
    }

    @Override
    public ModelResourceLocation getModelLocation(Item item) {
        String itemName = ItemStackUtil.getItemNameFromRegistry(item).func_110623_a();
        return this.getModelLocation(itemName);
    }

    @Override
    public ModelResourceLocation getModelLocation(String identifier) {
        return this.getModelLocation("forestry", identifier);
    }

    @Override
    public ModelResourceLocation getModelLocation(String modID, String identifier) {
        return new ModelResourceLocation(modID + ":" + identifier, "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockClient(Block block) {
        if (block instanceof IItemModelRegister) {
            this.itemModelRegisters.add((IItemModelRegister)block);
        }
        if (block instanceof IStateMapperRegister) {
            this.stateMapperRegisters.add((IStateMapperRegister)block);
        }
        if (block instanceof IColoredBlock) {
            this.blockColorList.add((IColoredBlock)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemClient(Item item) {
        if (item instanceof IItemModelRegister) {
            this.itemModelRegisters.add((IItemModelRegister)item);
        }
        if (item instanceof IColoredItem) {
            this.itemColorList.add((IColoredItem)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IItemModelRegister itemModelRegister : this.itemModelRegisters) {
            Item item = null;
            if (itemModelRegister instanceof Block) {
                item = Item.func_150898_a((Block)((Block)itemModelRegister));
            } else if (itemModelRegister instanceof Item) {
                item = (Item)itemModelRegister;
            }
            if (item == null) continue;
            itemModelRegister.registerModel(item, this);
        }
        for (IStateMapperRegister stateMapperRegister : this.stateMapperRegisters) {
            stateMapperRegister.registerStateMapper();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemAndBlockColors() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        for (IColoredBlock blockColor : this.blockColorList) {
            if (!(blockColor instanceof Block)) continue;
            blockColors.func_186722_a((IBlockColor)ColoredBlockBlockColor.INSTANCE, new Block[]{(Block)blockColor});
        }
        ItemColors itemColors = minecraft.getItemColors();
        for (IColoredItem itemColor : this.itemColorList) {
            if (!(itemColor instanceof Item)) continue;
            itemColors.func_186730_a((IItemColor)ColoredItemItemColor.INSTANCE, new Item[]{(Item)itemColor});
        }
    }

    public void registerCustomModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (BlockModelEntry blockModelEntry : this.customBlockModels) {
            registry.func_82595_a((Object)blockModelEntry.blockModelLocation, (Object)blockModelEntry.model);
            if (blockModelEntry.itemModelLocation == null) continue;
            registry.func_82595_a((Object)blockModelEntry.itemModelLocation, (Object)blockModelEntry.model);
        }
        for (ModelEntry modelEntry : this.customModels) {
            registry.func_82595_a((Object)modelEntry.modelLocation, (Object)modelEntry.model);
        }
    }

    public void registerCustomBlockModel(@Nonnull BlockModelEntry index) {
        this.customBlockModels.add(index);
    }

    public void registerCustomModel(@Nonnull ModelEntry index) {
        this.customModels.add(index);
    }

    static {
        ForestryAPI.modelManager = instance;
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredBlockBlockColor
    implements IBlockColor {
        public static final ColoredBlockBlockColor INSTANCE = new ColoredBlockBlockColor();

        private ColoredBlockBlockColor() {
        }

        public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock) {
                return ((IColoredBlock)block).colorMultiplier(state, worldIn, pos, tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredItemItemColor
    implements IItemColor {
        public static final ColoredItemItemColor INSTANCE = new ColoredItemItemColor();

        private ColoredItemItemColor() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            Item item = stack.func_77973_b();
            if (item instanceof IColoredItem) {
                return ((IColoredItem)item).getColorFromItemstack(stack, tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

