/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCoordinates;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketCamouflageSelectClient
extends PacketCoordinates
implements IForestryPacketClient {
    private ItemStack camouflageStack;
    private String camouflageType;
    private CamouflageSelectionType selectionType;

    public PacketCamouflageSelectClient() {
    }

    public PacketCamouflageSelectClient(ICamouflageHandler handler, String camouflageType, CamouflageSelectionType selectionType) {
        super(handler.getCoordinates());
        this.camouflageStack = handler.getCamouflageBlock(camouflageType);
        this.selectionType = selectionType;
        this.camouflageType = camouflageType;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.CAMOUFLAGE_SELECTION;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeShort(this.selectionType.ordinal());
        data.writeBoolean(this.camouflageType != null);
        if (this.camouflageType != null) {
            data.writeUTF(this.camouflageType);
        }
        data.writeItemStack(this.camouflageStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.selectionType = CamouflageSelectionType.values()[data.readShort()];
        if (data.readBoolean()) {
            this.camouflageType = data.readUTF();
        }
        this.camouflageStack = data.readItemStack();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) {
        TileEntity tile = this.getTarget(player.field_70170_p);
        ICamouflageHandler handler = null;
        if (this.selectionType == CamouflageSelectionType.MULTIBLOCK) {
            IMultiblockController controller;
            if (tile instanceof IMultiblockComponent && (controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)controller);
                handler.setCamouflageBlock(this.camouflageType, this.camouflageStack);
                for (IMultiblockComponent comp : controller.getComponents()) {
                    if (!(comp instanceof ICamouflagedTile)) continue;
                    ICamouflagedTile camBlock = (ICamouflagedTile)((Object)comp);
                    if (this.camouflageType == null || camBlock.getCamouflageType() == null || !camBlock.getCamouflageType().equals(this.camouflageType)) continue;
                    player.field_70170_p.func_175704_b(camBlock.getCoordinates(), camBlock.getCoordinates());
                }
            }
        } else if (this.selectionType == CamouflageSelectionType.TILE && tile instanceof ICamouflageHandler) {
            handler = (ICamouflageHandler)tile;
            handler.setCamouflageBlock(this.camouflageType, this.camouflageStack);
            player.field_70170_p.func_175704_b(this.getPos(), this.getPos());
        }
        if (handler != null) {
            handler.setCamouflageBlock(this.camouflageType, this.camouflageStack);
        }
    }
}

