/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketFXSignal
extends PacketCoordinates
implements IForestryPacketClient {
    private VisualFXType visualFX;
    private SoundFXType soundFX;
    private IBlockState blockState;

    public PacketFXSignal() {
    }

    public PacketFXSignal(VisualFXType type, BlockPos pos, IBlockState blockState) {
        this(type, SoundFXType.NONE, pos, blockState);
    }

    public PacketFXSignal(SoundFXType type, BlockPos pos, IBlockState blockState) {
        this(VisualFXType.NONE, type, pos, blockState);
    }

    public PacketFXSignal(VisualFXType visualFX, SoundFXType soundFX, BlockPos pos, IBlockState blockState) {
        super(pos);
        this.visualFX = visualFX;
        this.soundFX = soundFX;
        this.blockState = blockState;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeByte(this.visualFX.ordinal());
        data.writeByte(this.soundFX.ordinal());
        Block block = this.blockState.func_177230_c();
        data.writeVarInt(Block.func_149682_b((Block)block));
        data.writeVarInt(block.func_176201_c(this.blockState));
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.visualFX = VisualFXType.values()[data.readByte()];
        this.soundFX = SoundFXType.values()[data.readByte()];
        Block block = Block.func_149729_e((int)data.readVarInt());
        this.blockState = block.func_176203_a(data.readVarInt());
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        World world = player.func_130014_f_();
        BlockPos pos = this.getPos();
        if (this.visualFX == VisualFXType.BLOCK_BREAK) {
            Proxies.common.addBlockDestroyEffects(world, pos, this.blockState);
        }
        if (this.soundFX != SoundFXType.NONE) {
            Block block = this.blockState.func_177230_c();
            SoundType soundType = block.func_185467_w();
            if (this.soundFX == SoundFXType.BLOCK_BREAK) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
            } else if (this.soundFX == SoundFXType.BLOCK_PLACE) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
            }
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.FX_SIGNAL;
    }

    public static enum SoundFXType {
        NONE,
        BLOCK_BREAK,
        BLOCK_PLACE;

    }

    public static enum VisualFXType {
        NONE,
        BLOCK_BREAK,
        SAPLING_PLACE;

    }
}

