/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.MachinePropertiesTesr;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileEngine;
import forestry.energy.PluginEnergy;
import forestry.energy.blocks.MachinePropertiesEngine;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import forestry.energy.tiles.TileEuGenerator;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;

public enum BlockTypeEngine implements IBlockTypeTesr
{
    PEAT(BlockTypeEngine.createEngineProperties(TileEnginePeat.class, "peat", "/engine_copper")),
    BIOGAS(BlockTypeEngine.createEngineProperties(TileEngineBiogas.class, "biogas", "/engine_bronze")),
    CLOCKWORK(BlockTypeEngine.createEngineProperties(TileEngineClockwork.class, "clockwork", "/engine_clock")),
    ELECTRICAL(BlockTypeEngine.createEngineProperties(TileEngineElectric.class, "electrical", "/engine_tin")),
    GENERATOR(BlockTypeEngine.createMachineProperties(TileEuGenerator.class, "generator", "/generator"));

    public static final BlockTypeEngine[] VALUES;
    @Nonnull
    private final IMachinePropertiesTesr<?> machineProperties;

    private BlockTypeEngine(IMachinePropertiesTesr<?> machineProperties) {
        this.machineProperties = machineProperties;
    }

    protected static IMachinePropertiesTesr<?> createEngineProperties(@Nonnull Class<? extends TileEngine> teClass, @Nonnull String name, @Nonnull String textureName) {
        TileEntitySpecialRenderer<TileEngine> renderer = PluginEnergy.proxy.getRenderDefaultEngine("textures/blocks" + textureName + "_");
        return new MachinePropertiesEngine<TileEngine>(teClass, name, renderer, "forestry:blocks" + textureName + ".0");
    }

    protected static IMachinePropertiesTesr<?> createMachineProperties(@Nonnull Class<? extends TileBase> teClass, @Nonnull String name, @Nonnull String textureName) {
        TileEntitySpecialRenderer<TileBase> renderer = Proxies.render.getRenderDefaultMachine("textures/blocks" + textureName + "_");
        return new MachinePropertiesTesr<TileBase>(teClass, name, renderer, "forestry:blocks" + textureName + ".0");
    }

    @Nonnull
    public IMachinePropertiesTesr<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String func_176610_l() {
        return this.getMachineProperties().func_176610_l();
    }

    static {
        VALUES = BlockTypeEngine.values();
    }
}

