/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.network.packets.PacketWorktableRecipeUpdate;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.tiles.TileWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketWorktableRecipeRequest
extends PacketCoordinates
implements IForestryPacketServer {
    private MemorizedRecipe recipe;

    public PacketWorktableRecipeRequest() {
    }

    public PacketWorktableRecipeRequest(TileWorktable worktable, MemorizedRecipe recipe) {
        super(worktable);
        this.recipe = recipe;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeStreamable(this.recipe);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.recipe = data.readStreamable(MemorizedRecipe.class);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) throws IOException {
        TileEntity tile = this.getTarget(player.field_70170_p);
        if (tile instanceof TileWorktable) {
            TileWorktable worktable = (TileWorktable)tile;
            worktable.setCurrentRecipe(this.recipe);
            if (player.field_71070_bA instanceof ContainerWorktable) {
                ContainerWorktable containerWorktable = (ContainerWorktable)player.field_71070_bA;
                containerWorktable.updateCraftMatrix();
            }
            Proxies.net.sendNetworkPacket(new PacketWorktableRecipeUpdate(worktable), player.field_70170_p);
        }
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.WORKTABLE_RECIPE_REQUEST;
    }
}

