/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.squeezer;

import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.jei.squeezer.SqueezerContainerRecipeWrapper;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class SqueezerRecipeMaker {
    private SqueezerRecipeMaker() {
    }

    public static List<SqueezerRecipeWrapper> getSqueezerRecipes() {
        ArrayList<SqueezerRecipeWrapper> recipes = new ArrayList<SqueezerRecipeWrapper>();
        for (ISqueezerRecipe recipe : RecipeManagers.squeezerManager.recipes()) {
            recipes.add(new SqueezerRecipeWrapper(recipe));
        }
        return recipes;
    }

    public static List<SqueezerContainerRecipeWrapper> getSqueezerContainerRecipes() {
        ArrayList<SqueezerContainerRecipeWrapper> recipes = new ArrayList<SqueezerContainerRecipeWrapper>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            ISqueezerContainerRecipe containerRecipe = SqueezerRecipeManager.findMatchingContainerRecipe(data.filledContainer);
            if (containerRecipe == null) continue;
            recipes.add(new SqueezerContainerRecipeWrapper(containerRecipe, data.filledContainer));
        }
        return recipes;
    }
}

