/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.climate.EnumClimatiserModes;
import forestry.api.climate.EnumClimatiserTypes;
import forestry.api.climate.IClimateControl;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimatiserDefinition;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.climate.BiomeClimateControl;
import forestry.greenhouse.GreenhouseClimateSource;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class GreenhouseClimateWindow
extends GreenhouseClimateSource<TileGreenhouseWindow> {
    private Biome biome;

    public GreenhouseClimateWindow(int ticksForChange) {
        super(ticksForChange);
    }

    @Override
    public void changeClimate(int tickCount, IClimateRegion region) {
        World world = region.getWorld();
        IClimatiserDefinition definition = ((TileGreenhouseWindow)this.provider).getDefinition();
        Object logic = ((TileGreenhouseWindow)this.provider).getMultiblockLogic();
        IMultiblockController controller = logic.getController();
        Iterable<BlockPos> positionsInRange = ((TileGreenhouseWindow)this.provider).getPositionsInRange();
        TileGreenhouseWindow.WindowMode windowMode = ((TileGreenhouseWindow)this.provider).getMode();
        if (logic.isConnected() && controller.isAssembled() && controller instanceof IGreenhouseControllerInternal && positionsInRange != null && positionsInRange.iterator().hasNext() && region != null) {
            IGreenhouseControllerInternal greenhouseInternal = (IGreenhouseControllerInternal)controller;
            IClimateControl climateControl = this.getClimateControl(greenhouseInternal);
            float controlTemp = climateControl.getControlTemperature();
            float controlHum = climateControl.getControlHumidity();
            if (!greenhouseInternal.canWork()) {
                if (windowMode == TileGreenhouseWindow.WindowMode.OPEN) {
                    windowMode = TileGreenhouseWindow.WindowMode.CONTROL;
                    ((TileGreenhouseWindow)this.provider).setMode(windowMode);
                }
            } else if (windowMode == TileGreenhouseWindow.WindowMode.CONTROL) {
                windowMode = TileGreenhouseWindow.WindowMode.OPEN;
                ((TileGreenhouseWindow)this.provider).setMode(windowMode);
            }
            if (windowMode == TileGreenhouseWindow.WindowMode.OPEN) {
                int dimensionID = world.field_73011_w.getDimension();
                EnumClimatiserTypes type = definition.getType();
                EnumClimatiserModes mode = definition.getMode();
                float maxChange = definition.getChange();
                for (BlockPos pos : positionsInRange) {
                    double range;
                    double distance;
                    IClimatePosition position = region.getPositions().get(pos);
                    if (position == null || !((distance = pos.func_177951_i((Vec3i)((TileGreenhouseWindow)this.provider).getCoordinates())) <= (range = definition.getRange()))) continue;
                    float change = maxChange;
                    if (distance > 0.0) {
                        change = (float)((double)maxChange / distance);
                    }
                    if (this.canChange(type, EnumClimatiserTypes.TEMPERATURE)) {
                        if (position.getTemperature() < controlTemp) {
                            if (this.canChange(mode, EnumClimatiserModes.POSITIVE)) {
                                position.addTemperature(Math.min(change, controlTemp - position.getTemperature()));
                            }
                        } else if (position.getTemperature() > controlTemp && this.canChange(mode, EnumClimatiserModes.NEGATIVE)) {
                            position.addTemperature(-Math.min(position.getTemperature() - controlTemp, change));
                        }
                    }
                    if (!this.canChange(type, EnumClimatiserTypes.HUMIDITY)) continue;
                    if (position.getHumidity() < controlHum) {
                        if (!this.canChange(mode, EnumClimatiserModes.POSITIVE)) continue;
                        position.addHumidity(Math.min(change, controlHum - position.getHumidity()));
                        continue;
                    }
                    if (!(position.getHumidity() > controlHum) || !this.canChange(mode, EnumClimatiserModes.NEGATIVE)) continue;
                    position.addHumidity(-Math.min(position.getHumidity() - controlHum, change));
                }
            }
        }
    }

    @Override
    protected IClimateControl getClimateControl(IGreenhouseControllerInternal greenhouseInternal) {
        if (this.biome == null) {
            BlockPos pos = ((TileGreenhouseWindow)this.provider).getCoordinates();
            World world = ((TileGreenhouseWindow)this.provider).func_145831_w();
            this.biome = world.func_180494_b(pos);
        }
        return BiomeClimateControl.getControl(this.biome);
    }
}

