/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import reborncore.api.power.IPowerConfig;

public class RebornCoreConfig {
    public static Configuration config;
    private static RebornCoreConfig instance;
    public static String CATEGORY_POWER;
    public static String CATEGORY_MISC;
    protected static boolean enableRF;
    protected static boolean enableEU;
    protected static boolean enableTesla;
    protected static boolean enableForge;
    public static int euPerRF;
    public static boolean versionCheck;
    private static IPowerConfig powerConfig;

    public RebornCoreConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        RebornCoreConfig.Configs();
        config.save();
    }

    public static RebornCoreConfig initialize(File configFile) {
        if (instance != null) {
            throw new IllegalStateException("Cannot initialize TechReborn Config twice");
        }
        instance = new RebornCoreConfig(configFile);
        return instance;
    }

    public static RebornCoreConfig instance() {
        if (instance == null) {
            throw new IllegalStateException("Instance of TechReborn Config requested before initialization");
        }
        return instance;
    }

    public static void Configs() {
        enableRF = config.get(CATEGORY_POWER, "Allow RF", false, "Allow machines to be powered with RF").getBoolean();
        enableTesla = config.get(CATEGORY_POWER, "Allow Tesla", false, "Allow machines to be powered with Tesla").getBoolean();
        enableForge = config.get(CATEGORY_POWER, "Allow Forge", true, "Allow machines to be powered with Forges power system").getBoolean();
        enableEU = config.get(CATEGORY_POWER, "Allow EU", Loader.isModLoaded((String)"IC2"), "Allow machines to be powered with EU").getBoolean();
        euPerRF = config.get(CATEGORY_POWER, "EU - RF ratio", 4, "The Amount of RF to output from EU").getInt();
        versionCheck = config.get(CATEGORY_MISC, "Check for new versions", true, "Enable version checker").getBoolean();
        powerConfig = null;
    }

    public static IPowerConfig getRebornPower() {
        if (powerConfig == null) {
            powerConfig = new IPowerConfig(){

                @Override
                public boolean eu() {
                    return enableEU;
                }

                @Override
                public boolean rf() {
                    if (enableForge) {
                        return true;
                    }
                    return enableRF;
                }

                @Override
                public boolean tesla() {
                    return enableTesla;
                }

                @Override
                public boolean internal() {
                    return true;
                }

                @Override
                public boolean forge() {
                    return enableForge;
                }
            };
        }
        return powerConfig;
    }

    static {
        instance = null;
        CATEGORY_POWER = "power";
        CATEGORY_MISC = "misc";
        powerConfig = null;
    }
}

