/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.modmuss50.jsonDestroyer.api.IFakeTexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.IAdvancedRotationTexture;
import reborncore.common.blocks.IRotationTexture;
import reborncore.common.tile.TileMachineBase;

public abstract class BlockMachineBase
extends BaseTileBlock
implements IFakeTexturedBlock {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static ItemStack machineStack;
    public static ItemStack advancedMachineStack;
    boolean hasCustomStaes;

    public BlockMachineBase() {
        this(false);
    }

    public BlockMachineBase(boolean hasCustomStates) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.hasCustomStaes = hasCustomStates;
        if (!hasCustomStates) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        ACTIVE = PropertyBool.func_177716_a((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileMachineBase();
    }

    @Deprecated
    public void onBlockAdded(World world, int x, int y, int z) {
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.onBlockAdded(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (this.hasCustomStaes) {
            return;
        }
        if (!worldIn.field_72995_K) {
            IBlockState sate = worldIn.func_180495_p(pos.func_177978_c());
            Block block = sate.func_177230_c();
            IBlockState state1 = worldIn.func_180495_p(pos.func_177968_d());
            Block block1 = state1.func_177230_c();
            IBlockState state2 = worldIn.func_180495_p(pos.func_177976_e());
            Block block2 = state2.func_177230_c();
            IBlockState state3 = worldIn.func_180495_p(pos.func_177974_f());
            Block block3 = state3.func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j(state) && !block1.func_149730_j(state1)) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j(state1) && !block.func_149730_j(state)) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j(state2) && !block3.func_149730_j(state2)) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j(state3) && !block2.func_149730_j(state2)) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @Deprecated
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemstack) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.onBlockPlacedBy(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), placer, stack);
        this.setFacing(placer.func_174811_aO().func_176734_d(), worldIn, pos);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    @Deprecated
    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.dropInventory(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
        this.breakBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state.func_177230_c(), 0);
    }

    protected void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack != null && itemStack.field_77994_a > 0 && itemStack.func_77973_b() instanceof ItemBlock && (((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid)) continue;
            items.add(itemStack.func_77946_l());
        }
        for (ItemStack itemStack : items) {
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + dX), (double)((float)pos.func_177956_o() + dY), (double)((float)pos.func_177952_p() + dZ), itemStack.func_77946_l());
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.isAdvanced() ? advancedMachineStack.func_77946_l() : machineStack.func_77946_l());
        return items;
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (axis == null) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileMachineBase) {
            TileMachineBase machineBase = (TileMachineBase)tile;
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.fillBlockWithFluid(worldIn, pos, playerIn)) {
            return true;
        }
        if (this.onBlockActivated(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, side.func_176745_a(), hitX, hitY, hitZ)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Deprecated
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean fillBlockWithFluid(World world, BlockPos pos, EntityPlayer entityplayer) {
        TileEntity tile;
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null && (tile = world.func_175625_s(pos)) instanceof IFluidHandler) {
            IFluidHandler tank = (IFluidHandler)tile;
            if (FluidContainerRegistry.isContainer((ItemStack)current)) {
                ItemStack filled;
                FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
                if (liquid != null) {
                    int qty = tank.fill(null, liquid, true);
                    if (qty != 0 && !entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(FluidContainerRegistry.drainFluidContainer((ItemStack)current))) {
                                entityplayer.func_71019_a(FluidContainerRegistry.drainFluidContainer((ItemStack)current), false);
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, BlockMachineBase.consumeItem(current));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, FluidContainerRegistry.drainFluidContainer((ItemStack)current));
                        }
                    }
                    return true;
                }
                FluidStack available = tank.getTankInfo(null)[0].fluid;
                if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, BlockMachineBase.consumeItem(current));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, BlockMachineBase.consumeItem(current));
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, filled);
                        }
                    }
                    tank.drain(null, liquid.amount, true);
                    return true;
                }
            } else if (current.func_77973_b() instanceof IFluidContainerItem) {
                if (current.field_77994_a != 1) {
                    return false;
                }
                if (!world.field_72995_K) {
                    boolean mustFill;
                    IFluidContainerItem container = (IFluidContainerItem)current.func_77973_b();
                    FluidStack liquid = container.getFluid(current);
                    FluidStack tankLiquid = tank.getTankInfo(null)[0].fluid;
                    boolean mustDrain = liquid == null || liquid.amount == 0;
                    boolean bl = mustFill = tankLiquid == null || tankLiquid.amount == 0;
                    if (!mustDrain || !mustFill) {
                        if (mustDrain || !entityplayer.func_70093_af()) {
                            liquid = tank.drain(null, 1000, false);
                            int qtyToFill = container.fill(current, liquid, true);
                            tank.drain(null, qtyToFill, true);
                        } else if ((mustFill || entityplayer.func_70093_af()) && liquid.amount > 0) {
                            int qty = tank.fill(null, liquid, false);
                            tank.fill(null, container.drain(current, qty, true), true);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    @Override
    public String getTextureNameFromState(IBlockState blockState, EnumFacing facing) {
        if (this instanceof IRotationTexture) {
            IRotationTexture rotationTexture = (IRotationTexture)((Object)this);
            if (this.getFacing(blockState) == facing) {
                return this.isActive(blockState) ? rotationTexture.getFrontOn() : rotationTexture.getFrontOff();
            }
            if (facing == EnumFacing.UP) {
                return rotationTexture.getTop();
            }
            if (facing == EnumFacing.DOWN) {
                return rotationTexture.getBottom();
            }
            return rotationTexture.getSide();
        }
        if (this instanceof IAdvancedRotationTexture) {
            IAdvancedRotationTexture advancedRotationTexture = (IAdvancedRotationTexture)((Object)this);
            if (this.getFacing(blockState) == facing) {
                return advancedRotationTexture.getFront(this.isActive(blockState));
            }
            if (facing == EnumFacing.UP) {
                return advancedRotationTexture.getTop(this.isActive(blockState));
            }
            if (facing == EnumFacing.DOWN) {
                return advancedRotationTexture.getBottom(this.isActive(blockState));
            }
            return advancedRotationTexture.getSide(this.isActive(blockState));
        }
        return "techreborn:blocks/machine/machine_side";
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        int activeInt = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 0 : 4;
        return facingInt + activeInt;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        int facingInt = meta;
        if (facingInt > 4) {
            active = true;
            facingInt -= 4;
        }
        EnumFacing facing = this.getSideFromint(facingInt);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public boolean isActive(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        if (this.hasCustomStaes) {
            return;
        }
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public void setActive(Boolean active, World world, BlockPos pos) {
        if (this.hasCustomStaes) {
            return;
        }
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)active).func_177226_a((IProperty)FACING, (Comparable)facing);
        world.func_180501_a(pos, state, 3);
    }

    @Override
    public int amountOfStates() {
        return 9;
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        return 0;
    }
}

