/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.misc;

import com.google.common.base.Objects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import reborncore.common.util.WorldUtils;

public class ChunkCoord
implements Comparable<ChunkCoord> {
    private final ImmutablePair<Integer, Integer> data;

    private ChunkCoord(int x, int z) {
        this.data = ImmutablePair.of((Object)x, (Object)z);
    }

    private ChunkCoord(ChunkEvent event) {
        this(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
    }

    public static ChunkCoord of(int x, int z) {
        return new ChunkCoord(x, z);
    }

    public static ChunkCoord of(BlockPos coord) {
        return new ChunkCoord(coord.func_177958_n() >> 4, coord.func_177952_p() >> 4);
    }

    public static ChunkCoord of(ChunkEvent event) {
        return new ChunkCoord(event);
    }

    public boolean exists(World world) {
        return WorldUtils.chunkExists(world, (Integer)this.data.getLeft(), (Integer)this.data.getRight());
    }

    public boolean containsWorldCoord(BlockPos coord) {
        return this.equals(ChunkCoord.of(coord));
    }

    public int getX() {
        return (Integer)this.data.left;
    }

    public int getZ() {
        return (Integer)this.data.right;
    }

    public BlockPos localToWorldCoords(BlockPos coord) {
        return new BlockPos(((Integer)this.data.left << 4) + coord.func_177958_n(), coord.func_177956_o(), ((Integer)this.data.right << 4) + coord.func_177952_p());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.data.left, this.data.right});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkCoord that = (ChunkCoord)o;
        return ((Integer)this.data.left).equals(that.data.left) && ((Integer)this.data.right).equals(that.data.right);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("X", this.data.left).add("Z", this.data.right).toString();
    }

    @Override
    public int compareTo(ChunkCoord o) {
        return ((Integer)this.data.left).equals(o.data.left) ? ((Integer)this.data.right).compareTo((Integer)o.data.right) : ((Integer)this.data.left).compareTo((Integer)o.data.left);
    }
}

