/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.api.power.IPowerConfig;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.RFProviderTile;
import reborncore.common.powerSystem.forge.ForgePowerManager;
import reborncore.common.powerSystem.tesla.TeslaManager;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2")})
public abstract class TilePowerAcceptor
extends RFProviderTile
implements IEnergyReceiver,
IEnergyProvider,
IEnergyInterfaceTile,
IListInfoProvider,
IEnergyTile,
IEnergySink,
IEnergySource {
    public int tier;
    private double energy;
    ForgePowerManager forgePowerManager;
    protected boolean addedToEnet;

    public TilePowerAcceptor(int tier) {
        this.tier = tier;
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.created(this);
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    public void func_73660_a() {
        super.func_73660_a();
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.update(this);
        }
        this.onLoaded();
    }

    @Optional.Method(modid="IC2")
    public void onLoaded() {
        if (this.getPowerConfig().eu() && !this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    @Optional.Method(modid="IC2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.getPowerConfig().eu() && this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return 0.0;
        }
        return Math.min(this.getMaxPower() - this.getEnergy(), this.getMaxInput());
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return this.tier;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.setEnergy(this.getEnergy() + amount);
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return false;
        }
        return this.canAcceptEnergy(enumFacing);
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return false;
        }
        return this.canProvideEnergy(enumFacing);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return 0.0;
        }
        return Math.min(this.getEnergy(), this.getMaxOutput());
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        this.useEnergy((int)amount);
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        if (!this.getPowerConfig().rf()) {
            return false;
        }
        return this.canAcceptEnergy(from) || this.canProvideEnergy(from);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        if (!this.canAcceptEnergy(from)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(null) - this.getEnergyStored(null), Math.min((int)this.getMaxInput() * RebornCoreConfig.euPerRF, maxReceive *= RebornCoreConfig.euPerRF));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + (double)energyReceived);
        }
        return energyReceived / RebornCoreConfig.euPerRF;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        return (int)this.getEnergy() * RebornCoreConfig.euPerRF;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        return (int)this.getMaxPower() * RebornCoreConfig.euPerRF;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        if (!this.canProvideEnergy(from)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(null), Math.min(maxExtract *= RebornCoreConfig.euPerRF, maxExtract));
        if (!simulate) {
            this.setEnergy(this.energy - (double)energyExtracted);
        }
        return energyExtracted * RebornCoreConfig.euPerRF;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(double energy) {
        this.energy = energy;
        if (this.getEnergy() > this.getMaxPower()) {
            this.setEnergy(this.getMaxPower());
        } else if (this.energy < 0.0) {
            this.setEnergy(0.0);
        }
    }

    @Override
    public double addEnergy(double energy) {
        return this.addEnergy(energy, false);
    }

    @Override
    public double addEnergy(double energy, boolean simulate) {
        double energyReceived = Math.min(this.getMaxPower(), Math.min(this.getMaxPower(), energy));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public boolean canUseEnergy(double input) {
        return input <= this.energy;
    }

    @Override
    public double useEnergy(double energy) {
        return this.useEnergy(energy, false);
    }

    @Override
    public double useEnergy(double extract, boolean simulate) {
        if (extract > this.energy) {
            double tempEnergy = this.energy;
            this.setEnergy(0.0);
            return tempEnergy;
        }
        if (!simulate) {
            this.setEnergy(this.energy - extract);
        }
        return extract;
    }

    @Override
    public boolean canAddEnergy(double energy) {
        return this.energy + energy <= this.getMaxPower();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        this.energy = data.func_74769_h("energy");
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.readFromNBT(tag, this);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energy);
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.writeToNBT(tag, this);
        }
        return tag;
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        this.energy = data.func_74769_h("energy");
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energy);
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
        return tag;
    }

    @Override
    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.LIGHT_PURPLE + "Energy buffer Size " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxPower()));
        if (this.getMaxInput() != 0.0) {
            info.add(TextFormatting.LIGHT_PURPLE + "Max Input " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxInput()));
        }
        if (this.getMaxOutput() != 0.0) {
            info.add(TextFormatting.LIGHT_PURPLE + "Max Output " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxOutput()));
        }
        info.add(TextFormatting.LIGHT_PURPLE + "Tier " + TextFormatting.GREEN + (Object)((Object)this.getTier()));
    }

    public double getFreeSpace() {
        return this.getMaxPower() - this.energy;
    }

    public void charge(int slot) {
    }

    public int getEnergyScaled(int scale) {
        return (int)(this.energy * (double)scale / this.getMaxPower());
    }

    public IPowerConfig getPowerConfig() {
        return RebornCoreConfig.getRebornPower();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig()) && TeslaManager.manager.hasCapability(capability, facing, this)) {
            return true;
        }
        if (this.getPowerConfig().forge() && capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            T teslaCap = TeslaManager.manager.getCapability(capability, facing, this);
            if (capability != null) {
                return teslaCap;
            }
        }
        if (this.getPowerConfig().forge() && capability == CapabilityEnergy.ENERGY) {
            if (this.forgePowerManager == null) {
                this.forgePowerManager = new ForgePowerManager(this, facing);
            }
            this.forgePowerManager.setFacing(facing);
            return (T)this.forgePowerManager;
        }
        return (T)super.getCapability(capability, facing);
    }
}

