/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.tile;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IContainerProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.gui.BaseSlot;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.container.RebornContainer;
import reborncore.common.packets.PacketHandler;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;

public class TileMachineBase
extends TileEntity
implements ITickable,
IInventory,
ISidedInventory {
    public void syncWithAll() {
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendPacketToAllPlayers((Packet)this.func_189518_D_(), this.field_145850_b);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189515_b(new NBTTagCompound());
        this.func_189515_b(compound);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        this.updateEntity();
        if (this.getCrafterForTile().isPresent()) {
            this.getCrafterForTile().get().updateEntity();
        }
    }

    @Deprecated
    public void updateEntity() {
    }

    public int getFacingInt() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockMachineBase) {
            return ((BlockMachineBase)block).getFacing(this.field_145850_b.func_180495_p(this.field_174879_c)).func_176745_a();
        }
        return 0;
    }

    public EnumFacing getFacingEnum() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockMachineBase) {
            return ((BlockMachineBase)block).getFacing(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        return null;
    }

    public void setFacing(EnumFacing enumFacing) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockMachineBase) {
            ((BlockMachineBase)block).setFacing(enumFacing, this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean isActive() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockMachineBase) {
            return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMachineBase.ACTIVE);
        }
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    protected Optional<Inventory> getInventoryForTile() {
        if (this instanceof IInventoryProvider) {
            IInventoryProvider inventory = (IInventoryProvider)((Object)this);
            if (inventory.getInventory() == null) {
                return Optional.empty();
            }
            return Optional.of(inventory.getInventory());
        }
        return Optional.empty();
    }

    protected Optional<RecipeCrafter> getCrafterForTile() {
        if (this instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider crafterProvider = (IRecipeCrafterProvider)((Object)this);
            if (crafterProvider.getRecipeCrafter() == null) {
                return Optional.empty();
            }
            return Optional.of(crafterProvider.getRecipeCrafter());
        }
        return Optional.empty();
    }

    protected Optional<RebornContainer> getContainerForTile() {
        if (this instanceof IContainerProvider) {
            IContainerProvider containerProvider = (IContainerProvider)((Object)this);
            if (containerProvider.getContainer() == null) {
                return Optional.empty();
            }
            return Optional.of(containerProvider.getContainer());
        }
        return Optional.empty();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().readFromNBT(tagCompound);
        }
        if (this.getCrafterForTile().isPresent()) {
            this.getCrafterForTile().get().readFromNBT(tagCompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().writeToNBT(tagCompound);
        }
        if (this.getCrafterForTile().isPresent()) {
            this.getCrafterForTile().get().writeToNBT(tagCompound);
        }
        return tagCompound;
    }

    public int func_70302_i_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70301_a(index);
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70298_a(index, count);
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70304_b(index);
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_70299_a(index, stack);
        }
    }

    public int func_70297_j_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70300_a(player);
        }
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174886_c(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_94041_b(index, stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_174887_a_(id);
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174885_b(id, value);
        }
    }

    public int func_174890_g() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_174890_g();
        }
        return 0;
    }

    public void func_174888_l() {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174888_l();
        }
    }

    public String func_70005_c_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70005_c_();
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_145818_k_();
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_145748_c_();
        }
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.getContainerForTile().isPresent()) {
            RebornContainer container = this.getContainerForTile().get();
            ArrayList<Integer> intList = new ArrayList<Integer>();
            for (int i = 0; i < container.slotMap.size(); ++i) {
                intList.add(i);
            }
            int[] intArr = ArrayUtils.toPrimitive((Integer[])intList.toArray(new Integer[intList.size()]));
            return intArr;
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (this.getContainerForTile().isPresent()) {
            Slot slot;
            RebornContainer container = this.getContainerForTile().get();
            if (container.slotMap.containsKey(index) && (slot = (Slot)container.slotMap.get(index)).func_75214_a(itemStackIn)) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (this.getContainerForTile().isPresent()) {
            BaseSlot slot;
            RebornContainer container = this.getContainerForTile().get();
            if (container.slotMap.containsKey(index) && (slot = container.slotMap.get(index)).canWorldBlockRemove()) {
                return true;
            }
        }
        return false;
    }
}

