/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.UniversalBucket;
import reborncore.common.util.ItemUtils;

public class FluidUtils {
    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input != null) {
            int used;
            FluidStack fluidInContainer = FluidUtils.getFluidStackInContainer(input);
            ItemStack emptyItem = input.func_77973_b().getContainerItem(input);
            if (input.func_77973_b() instanceof UniversalBucket) {
                emptyItem = ((UniversalBucket)input.func_77973_b()).getEmpty();
            }
            if (fluidInContainer != null && (emptyItem == null || output == null || output.field_77994_a < output.func_77976_d() && ItemUtils.isItemEqual(output, emptyItem, true, true)) && (used = fluidHandler.fill(null, fluidInContainer, false)) >= fluidInContainer.amount && fluidHandler.canFill(EnumFacing.UP, fluidInContainer.getFluid())) {
                fluidHandler.fill(null, fluidInContainer, true);
                if (emptyItem != null) {
                    if (output == null) {
                        inv.func_70299_a(outputSlot, emptyItem);
                    } else {
                        ++output.field_77994_a;
                    }
                }
                inv.func_70298_a(inputSlot, 1);
                return true;
            }
        }
        return false;
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        FluidStack fluidInContainer;
        FluidStack drain;
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = FluidUtils.getFilledContainer(fluidToFill, input);
        if (filled != null && (output == null || output.field_77994_a < output.func_77976_d() && ItemUtils.isItemEqual(filled, output, true, true)) && (drain = fluidHandler.drain(null, fluidInContainer = FluidUtils.getFluidStackInContainer(filled), false)) != null && drain.amount == fluidInContainer.amount) {
            fluidHandler.drain(null, fluidInContainer, true);
            if (output == null) {
                inv.func_70299_a(outputSlot, filled);
            } else {
                ++output.field_77994_a;
            }
            inv.func_70298_a(inputSlot, 1);
            return true;
        }
        return false;
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null || empty == null) {
            return null;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)empty);
    }
}

