/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import reborncore.common.packets.PacketHandler;

public class Tank
extends FluidTank {
    private final String name;
    private FluidStack lastBeforeUpdate = null;

    public Tank(String name, int capacity, TileEntity tile) {
        super(capacity);
        this.name = name;
        this.tile = tile;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tankData = new NBTTagCompound();
        super.writeToNBT(tankData);
        nbt.func_74782_a(this.name, (NBTBase)tankData);
        return nbt;
    }

    public void setFluidAmount(int amount) {
        if (this.fluid != null) {
            this.fluid.amount = amount;
        }
    }

    public final FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.name)) {
            this.setFluid(null);
            NBTTagCompound tankData = nbt.func_74775_l(this.name);
            super.readFromNBT(tankData);
        }
        return this;
    }

    public void compareAndUpdate() {
        if (this.tile == null || this.tile.func_145831_w().field_72995_K) {
            return;
        }
        FluidStack current = this.getFluid();
        if (current != null) {
            if (this.lastBeforeUpdate != null) {
                if (Math.abs(current.amount - this.lastBeforeUpdate.amount) >= 500) {
                    PacketHandler.sendPacketToAllPlayers((Packet)this.tile.func_189518_D_(), this.tile.func_145831_w());
                    this.lastBeforeUpdate = current.copy();
                } else if (this.lastBeforeUpdate.amount < this.getCapacity() && current.amount == this.getCapacity() || this.lastBeforeUpdate.amount == this.getCapacity() && current.amount < this.getCapacity()) {
                    PacketHandler.sendPacketToAllPlayers((Packet)this.tile.func_189518_D_(), this.tile.func_145831_w());
                    this.lastBeforeUpdate = current.copy();
                }
            } else {
                PacketHandler.sendPacketToAllPlayers((Packet)this.tile.func_189518_D_(), this.tile.func_145831_w());
                this.lastBeforeUpdate = current.copy();
            }
        } else if (this.lastBeforeUpdate != null) {
            PacketHandler.sendPacketToAllPlayers((Packet)this.tile.func_189518_D_(), this.tile.func_145831_w());
            this.lastBeforeUpdate = null;
        }
    }
}

