/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.common.util.Inventory;

public class InventoryStackHandler
implements IItemHandler,
IItemHandlerModifiable {
    Inventory inventory;

    public InventoryStackHandler(Inventory inventory) {
        this.inventory = inventory;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int getSlots() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.inventory.contents[slot];
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (existing == null) {
                this.inventory.contents[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.inventory.contents[slot];
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.inventory.contents[slot] = null;
            }
            return existing;
        }
        if (!simulate) {
            this.inventory.contents[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.inventory.contents.length) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.inventory.contents.length + ")");
        }
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }
}

