/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.raytrace;

import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import reborncore.mcmultipart.multipart.IMultipart;
import reborncore.mcmultipart.raytrace.PartMOP;

public final class RayTraceUtils {
    private RayTraceUtils() {
    }

    public static Vec3d getStart(EntityPlayer player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vec3d getEnd(EntityPlayer player) {
        double reachDistance = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : (player.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = RayTraceUtils.getStart(player);
        return start.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
    }

    public static AdvancedRayTraceResult collisionRayTrace(World world, BlockPos pos, EntityPlayer player, Collection<AxisAlignedBB> boxes) {
        return RayTraceUtils.collisionRayTrace(world, pos, RayTraceUtils.getStart(player), RayTraceUtils.getEnd(player), boxes);
    }

    public static AdvancedRayTraceResult collisionRayTrace(World world, BlockPos pos, EntityPlayer player, AxisAlignedBB aabb, int subHit, Object hitInfo) {
        return RayTraceUtils.collisionRayTrace(pos, RayTraceUtils.getStart(player), RayTraceUtils.getEnd(player), aabb, subHit, hitInfo);
    }

    public static AdvancedRayTraceResult collisionRayTrace(World world, BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (AxisAlignedBB aabb : boxes) {
            double d;
            AdvancedRayTraceResult result;
            AdvancedRayTraceResult advancedRayTraceResult = result = aabb == null ? null : RayTraceUtils.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo) {
        RayTraceResult result = bounds.func_186670_a(pos).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return new AdvancedRayTraceResult(result, bounds);
    }

    public static class AdvancedRayTraceResultPart
    extends AdvancedRayTraceResultBase<PartMOP> {
        public AdvancedRayTraceResultPart(AdvancedRayTraceResult result, IMultipart part) {
            super(new PartMOP(result.hit, part), result.bounds);
        }

        public AdvancedRayTraceResultPart(PartMOP mop, AxisAlignedBB bounds) {
            super(mop, bounds);
        }
    }

    public static class AdvancedRayTraceResult
    extends AdvancedRayTraceResultBase<RayTraceResult> {
        public AdvancedRayTraceResult(RayTraceResult mop, AxisAlignedBB bounds) {
            super(mop, bounds);
        }
    }

    private static class AdvancedRayTraceResultBase<T extends RayTraceResult> {
        public final AxisAlignedBB bounds;
        public final T hit;

        public AdvancedRayTraceResultBase(T mop, AxisAlignedBB bounds) {
            this.hit = mop;
            this.bounds = bounds;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) {
            return ((RayTraceResult)this.hit).field_72307_f.func_72436_e(vec);
        }
    }
}

