/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import mod.chiselsandbits.chiseledblock.data.VoxelBlob;

public class BitIterator {
    private static final int zInc = 256;
    private static final int yInc = 16;
    private static final int yMax = 256;
    private static final int zMax = 4096;
    private int zOffset = 0;
    private int yOffset = 0;
    private int combined = 0;
    private int bit;
    public int x = -1;
    public int y;
    public int z;

    protected void yPlus() {
        this.x = 0;
        ++this.y;
        this.yOffset += 16;
    }

    protected void zPlus() {
        this.y = 0;
        this.yOffset = 0;
        ++this.z;
        this.zOffset += 256;
    }

    public boolean hasNext() {
        ++this.x;
        if (this.x >= 16) {
            this.yPlus();
            if (this.yOffset >= 256) {
                this.zPlus();
                if (this.zOffset >= 4096) {
                    this.done();
                    return false;
                }
            }
            this.combined = this.zOffset | this.yOffset;
        }
        this.bit = this.combined | this.x;
        return true;
    }

    protected void done() {
    }

    public int getNext(VoxelBlob blob) {
        return blob.getBit(this.bit);
    }

    public void setNext(VoxelBlob blob, int value) {
        blob.putBit(this.bit, value);
    }
}

