/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.lang.ref.WeakReference;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.chiseledblock.ModelRenderState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;

public final class VoxelNeighborRenderTracker {
    static final int IS_DYNAMIC = 1;
    static final int IS_LOCKED = 2;
    static final int IS_STATIC = 4;
    private WeakReference<VoxelBlobStateReference> lastCenter;
    private ModelRenderState lrs = null;
    private byte isDynamic;
    private boolean shouldUpdate = false;
    Integer[] faceCount = new Integer[4];
    private final ModelRenderState sides = new ModelRenderState(null);

    public void unlockDynamic() {
        this.isDynamic = (byte)(this.isDynamic & 0xFFFFFFFD);
    }

    public VoxelNeighborRenderTracker() {
        this.faceCount = new Integer[BlockRenderLayer.values().length];
        if (ChiselsAndBits.getConfig().defaultToDynamicRenderer) {
            this.isDynamic = (byte)3;
            for (int x = 0; x < this.faceCount.length; ++x) {
                this.faceCount[x] = ChiselsAndBits.getConfig().dynamicModelFaceCount + 1;
            }
        } else if (ChiselsAndBits.getConfig().forceDynamicRenderer) {
            this.isDynamic = (byte)3;
        }
    }

    public boolean isAboveLimit() {
        if (FMLClientHandler.instance().hasOptifine()) {
            return false;
        }
        if (ChiselsAndBits.getConfig().forceDynamicRenderer) {
            return true;
        }
        int faces = 0;
        for (int x = 0; x < this.faceCount.length; ++x) {
            if (this.faceCount[x] == null) {
                return false;
            }
            faces += this.faceCount[x].intValue();
        }
        return faces >= ChiselsAndBits.getConfig().dynamicModelFaceCount;
    }

    public void setAbovelimit(BlockRenderLayer layer, int fc) {
        this.faceCount[layer.ordinal()] = fc;
    }

    public boolean isDynamic() {
        return (this.isDynamic & 1) != 0;
    }

    public void update(boolean isDynamic, IBlockAccess access, BlockPos pos) {
        if (access == null || pos == null) {
            return;
        }
        if ((this.isDynamic & 2) == 0) {
            this.isDynamic = (byte)(isDynamic ? 1 : 4);
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(access, pos.func_177972_a(f));
            if (tebc != null) {
                this.update(f, (VoxelBlobStateReference)tebc.getBasicState().getValue(BlockChiseled.UProperty_VoxelBlob));
                continue;
            }
            this.update(f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(EnumFacing f, VoxelBlobStateReference value) {
        if (this.sides.get(f) == value) {
            return;
        }
        VoxelNeighborRenderTracker voxelNeighborRenderTracker = this;
        synchronized (voxelNeighborRenderTracker) {
            this.sides.put(f, value);
            this.lrs = null;
        }
    }

    public ModelRenderState getRenderState(VoxelBlobStateReference data) {
        if (this.lrs == null || this.lastCenter == null) {
            this.lrs = new ModelRenderState(this.sides);
            this.updateCenter(data);
        } else if (this.lastCenter.get() != data) {
            this.updateCenter(data);
            this.lrs = new ModelRenderState(this.sides);
        }
        return this.lrs;
    }

    private void updateCenter(VoxelBlobStateReference data) {
        this.lastCenter = new WeakReference<VoxelBlobStateReference>(data);
    }

    public void triggerUpdate() {
        this.shouldUpdate = true;
    }

    public boolean isShouldUpdate() {
        boolean res = this.shouldUpdate;
        this.shouldUpdate = false;
        return res;
    }
}

