/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.iterators;

import mod.chiselsandbits.chiseledblock.iterators.BaseChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselExtrudeIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.helpers.IVoxelSrc;
import mod.chiselsandbits.modes.ChiselMode;
import net.minecraft.util.EnumFacing;

public class ChiselTypeIterator
extends BaseChiselIterator
implements ChiselIterator {
    private final int full_size;
    private final int max_dim;
    private int x_range = 1;
    private int y_range = 1;
    private int z_range = 1;
    private int x;
    private int y;
    private int z;
    private final int original_x;
    private final int original_y;
    private final int original_z;
    public final EnumFacing side;
    final ChiselMode mode;
    private final int parts;
    private int offset = -1;

    public ChiselTypeIterator(int dim, int x, int y, int z, int x_size, int y_size, int z_size, EnumFacing side) {
        this.full_size = dim;
        this.max_dim = dim - 1;
        this.mode = ChiselMode.DRAWN_REGION;
        this.side = side;
        this.x_range = x_size;
        this.y_range = y_size;
        this.z_range = z_size;
        this.parts = this.x_range * this.y_range * this.z_range;
        this.original_x = x;
        this.original_y = y;
        this.original_z = z;
    }

    public static ChiselIterator create(int dim, int x, int y, int z, IVoxelSrc source, ChiselMode mode, EnumFacing side, boolean place) {
        if (mode == ChiselMode.CONNECTED_PLANE) {
            return new ChiselExtrudeIterator(dim, x, y, z, source, mode, side, place);
        }
        return new ChiselTypeIterator(dim, x, y, z, source, mode, side);
    }

    private ChiselTypeIterator(int dim, int x, int y, int z, IVoxelSrc source, ChiselMode mode, EnumFacing side) {
        int offset = 0;
        this.full_size = dim;
        this.max_dim = dim - 1;
        this.side = side;
        this.mode = mode;
        block0 : switch (mode) {
            case CUBE_SMALL: {
                this.x_range = 3;
                this.y_range = 3;
                this.z_range = 3;
                offset = -1;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case SNAP2: {
                x -= x % 2;
                y -= y % 2;
                z -= z % 2;
                this.x_range = 2;
                this.y_range = 2;
                this.z_range = 2;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case SNAP4: {
                x -= x % 4;
                y -= y % 4;
                z -= z % 4;
                this.x_range = 4;
                this.y_range = 4;
                this.z_range = 4;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case SNAP8: {
                x -= x % 8;
                y -= y % 8;
                z -= z % 8;
                this.x_range = 8;
                this.y_range = 8;
                this.z_range = 8;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case LINE: {
                this.parts = this.full_size;
                switch (side) {
                    case DOWN: 
                    case UP: {
                        y = 0;
                        this.y_range = this.full_size;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        z = 0;
                        this.z_range = this.full_size;
                        break block0;
                    }
                    case WEST: 
                    case EAST: {
                        x = 0;
                        this.x_range = this.full_size;
                        break block0;
                    }
                }
                throw new NullPointerException();
            }
            case PLANE: {
                this.parts = this.full_size * this.full_size;
                switch (side) {
                    case DOWN: 
                    case UP: {
                        x = 0;
                        z = 0;
                        this.x_range = this.full_size;
                        this.z_range = this.full_size;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        x = 0;
                        y = 0;
                        this.x_range = this.full_size;
                        this.y_range = this.full_size;
                        break block0;
                    }
                    case WEST: 
                    case EAST: {
                        y = 0;
                        z = 0;
                        this.y_range = this.full_size;
                        this.z_range = this.full_size;
                        break block0;
                    }
                }
                throw new NullPointerException();
            }
            case CUBE_MEDIUM: {
                this.x_range = 5;
                this.y_range = 5;
                this.z_range = 5;
                offset = -2;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case CUBE_LARGE: {
                this.x_range = 7;
                this.y_range = 7;
                this.z_range = 7;
                offset = -3;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case DRAWN_REGION: 
            case SINGLE: {
                this.parts = 1;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        this.original_x = Math.max(0, Math.min(this.full_size - this.x_range, x + offset));
        this.original_y = Math.max(0, Math.min(this.full_size - this.y_range, y + offset));
        this.original_z = Math.max(0, Math.min(this.full_size - this.z_range, z + offset));
    }

    @Override
    public boolean hasNext() {
        if (++this.offset != 0) {
            ++this.x;
            boolean x_up = false;
            if (this.x >= this.x_range) {
                ++this.y;
                this.x = 0;
                x_up = true;
            }
            if (this.y >= this.y_range && x_up) {
                ++this.z;
                this.y = 0;
            }
        }
        return this.offset < this.parts;
    }

    @Override
    public int x() {
        return Math.max(0, Math.min(this.max_dim, this.original_x + this.x));
    }

    @Override
    public int y() {
        return Math.max(0, Math.min(this.max_dim, this.original_y + this.y));
    }

    @Override
    public int z() {
        return Math.max(0, Math.min(this.max_dim, this.original_z + this.z));
    }

    @Override
    public EnumFacing side() {
        return this.side;
    }
}

