/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.commands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.helpers.ModelQuadReader;
import mod.chiselsandbits.render.helpers.ModelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class JsonModelExport
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "c&b.exportmodel";
    }

    public String func_71518_a(ICommandSender sender) {
        return "chiselsandbits.commands.exportjsonmodel.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer player = ClientSide.instance.getPlayer();
        ItemStack is = player.func_184614_ca();
        if (is != null && is.func_77973_b() != null) {
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(is);
            model = model.func_188617_f().handleItemState(model, is, player.func_130014_f_(), (EntityLivingBase)player);
            HashMap<TextureAtlasSprite, String> textures = new HashMap<TextureAtlasSprite, String>();
            for (EnumFacing face : EnumFacing.field_82609_l) {
                this.outputFaces(model.func_188616_a(null, face, 0L), face, textures);
            }
            this.outputFaces(model.func_188616_a(null, null, 0L), null, textures);
            String data = "N/A";
            if (is.func_77973_b() instanceof ItemBlockChiseled && is.func_77942_o()) {
                VoxelBlob blob = ModUtil.getBlobFromStack(is, null);
                byte[] bd = blob.blobToBytes(VoxelBlob.VERSION_CROSSWORLD);
                data = Arrays.toString(bd);
            }
            StringBuilder output = new StringBuilder("{ \"source\": \"").append(data).append("\",\n\"textures\": {");
            for (TextureAtlasSprite s : textures.keySet()) {
                output.append("\"").append(System.identityHashCode(s)).append("\": \"").append(s.func_94215_i()).append("\",\n");
            }
            if (!textures.values().isEmpty()) {
                output.deleteCharAt(output.length() - 1);
                output.deleteCharAt(output.length() - 1);
            }
            output.append("},\n\"elements\": [\n");
            for (String json : textures.values()) {
                output.append(json);
            }
            if (!textures.values().isEmpty()) {
                output.deleteCharAt(output.length() - 1);
                output.deleteCharAt(output.length() - 1);
            }
            output.append("\n],\n\"display\": { \"thirdperson\": { \"rotation\": [ 10, -45, 170 ], \"translation\": [ 0, 1.5, -2.75 ], \"scale\": [ 0.375, 0.375, 0.375 ] } } }");
            String modelJSON = output.toString();
            GuiScreen.func_146275_d((String)modelJSON);
            sender.func_145747_a((ITextComponent)new TextComponentString("Json Posted to Clipboard"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("No Item in Hand."));
        }
    }

    private void outputFaces(List<BakedQuad> faceQuads, EnumFacing cullFace, Map<TextureAtlasSprite, String> textures) {
        for (BakedQuad quad : faceQuads) {
            try {
                TextureAtlasSprite sprite = ModelUtil.findQuadTexture(quad);
                ModelQuadReader mqr = new ModelQuadReader("#" + System.identityHashCode(sprite), sprite, quad.func_178210_d(), cullFace);
                quad.pipe((IVertexConsumer)mqr);
                String newJSON = mqr.toString();
                String old = textures.get(sprite);
                if (old == null) {
                    old = "";
                }
                textures.put(sprite, old + newJSON);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }
}

