/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitBrush;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BitAccess
implements IBitAccess {
    private final World world;
    private final BlockPos pos;
    private final VoxelBlob blob;
    private final VoxelBlob filler;
    private final Map<Integer, IBitBrush> brushes = new HashMap<Integer, IBitBrush>();

    public VoxelBlob getNativeBlob() {
        return this.blob;
    }

    public BitAccess(World worldIn, BlockPos pos, VoxelBlob blob, VoxelBlob filler) {
        this.world = worldIn;
        this.pos = pos;
        this.blob = blob;
        this.filler = filler;
    }

    @Override
    public IBitBrush getBitAt(int x, int y, int z) {
        return this.getBrushForState(this.blob.getSafe(x, y, z));
    }

    private IBitBrush getBrushForState(int state) {
        IBitBrush brush = this.brushes.get(state);
        if (brush == null) {
            brush = new BitBrush(state);
            this.brushes.put(state, brush);
        }
        return brush;
    }

    @Override
    public void setBitAt(int x, int y, int z, IBitBrush bit) throws APIExceptions.SpaceOccupied {
        int state = 0;
        if (bit instanceof BitBrush) {
            state = bit.getStateID();
        }
        if (this.filler.get(x &= 0xF, y &= 0xF, z &= 0xF) != 0) {
            throw new APIExceptions.SpaceOccupied();
        }
        this.blob.set(x, y, z, state);
    }

    @Override
    public void commitChanges(boolean triggerUpdates) {
        TileEntityBlockChiseled tile = ModUtil.getChiseledTileEntity(this.world, this.pos, true);
        VoxelBlob.BlobStats cb = this.blob.getVoxelStats();
        if (tile == null && BlockChiseled.replaceWithChisled(this.world, this.pos, this.world.func_180495_p(this.pos), cb.mostCommonState, false)) {
            tile = ModUtil.getChiseledTileEntity(this.world, this.pos, true);
        }
        if (tile != null) {
            VoxelBlobStateReference before = tile.getBlobStateReference();
            tile.setBlob(this.blob, triggerUpdates);
            VoxelBlobStateReference after = tile.getBlobStateReference();
            UndoTracker.getInstance().add(this.world, this.pos, before, after);
        }
    }

    @Override
    public void commitChanges() {
        this.commitChanges(true);
    }

    @Override
    public ItemStack getBitsAsItem(EnumFacing side, ItemType type, boolean crossWorld) {
        ItemStack itemstack;
        if (type == null) {
            return null;
        }
        VoxelBlob.BlobStats cb = this.blob.getVoxelStats();
        if (cb.mostCommonState == 0) {
            return null;
        }
        NBTBlobConverter c = new NBTBlobConverter();
        c.setBlob(this.blob);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        c.writeChisleData(nbttagcompound, crossWorld);
        if (type == ItemType.CHISLED_BLOCK) {
            IBlockState state = Block.func_176220_d((int)cb.mostCommonState);
            BlockChiseled blk = ChiselsAndBits.getBlocks().getConversion(state);
            if (blk == null) {
                return null;
            }
            itemstack = new ItemStack((Block)blk, 1);
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        } else {
            switch (type) {
                case MIRROR_DESIGN: {
                    itemstack = new ItemStack((Item)ChiselsAndBits.getItems().itemMirrorprint);
                    break;
                }
                case NEGATIVE_DESIGN: {
                    itemstack = new ItemStack((Item)ChiselsAndBits.getItems().itemNegativeprint);
                    break;
                }
                case POSITIVE_DESIGN: {
                    itemstack = new ItemStack((Item)ChiselsAndBits.getItems().itemPositiveprint);
                    break;
                }
                default: {
                    return null;
                }
            }
            itemstack.func_77982_d(nbttagcompound);
        }
        if (side != null) {
            ModUtil.setSide(itemstack, side);
        }
        return itemstack;
    }

    @Override
    public ItemStack getBitsAsItem(EnumFacing side, ItemType type) {
        return this.getBitsAsItem(side, type, false);
    }

    @Override
    public void visitBits(IBitVisitor visitor) {
        BitIterator bi = new BitIterator();
        IBitBrush brush = this.getBrushForState(0);
        while (bi.hasNext()) {
            IBitBrush after;
            if (bi.getNext(this.filler) != 0) continue;
            int stateID = bi.getNext(this.blob);
            if (stateID != brush.getStateID()) {
                brush = this.getBrushForState(stateID);
            }
            if (brush == (after = visitor.visitBit(bi.x, bi.y, bi.z, brush))) continue;
            if (after == null) {
                bi.setNext(this.blob, 0);
                continue;
            }
            bi.setNext(this.blob, after.getStateID());
        }
    }
}

