/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.modes;

import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.modes.IToolMode;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public enum ChiselMode implements IToolMode
{
    SINGLE(LocalStrings.ChiselModeSingle),
    SNAP2(LocalStrings.ChiselModeSnap2),
    SNAP4(LocalStrings.ChiselModeSnap4),
    SNAP8(LocalStrings.ChiselModeSnap8),
    LINE(LocalStrings.ChiselModeLine),
    PLANE(LocalStrings.ChiselModePlane),
    CONNECTED_PLANE(LocalStrings.ChiselModeConnectedPlane),
    CUBE_SMALL(LocalStrings.ChiselModeCubeSmall),
    CUBE_MEDIUM(LocalStrings.ChiselModeCubeMedium),
    CUBE_LARGE(LocalStrings.ChiselModeCubeLarge),
    DRAWN_REGION(LocalStrings.ChiselModeDrawnRegion);

    public final LocalStrings string;
    public boolean isDisabled = false;
    public Object binding;

    private ChiselMode(LocalStrings str) {
        this.string = str;
    }

    public static ChiselMode getMode(ItemStack stack) {
        if (stack != null) {
            try {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null && nbt.func_74764_b("mode")) {
                    return ChiselMode.valueOf(nbt.func_74779_i("mode"));
                }
            }
            catch (IllegalArgumentException nbt) {
            }
            catch (Exception e) {
                Log.logError("Unable to determine mode.", e);
            }
        }
        return SINGLE;
    }

    @Override
    public void setMode(ItemStack stack) {
        if (stack != null) {
            stack.func_77983_a("mode", (NBTBase)new NBTTagString(this.name()));
        }
    }

    @Override
    public LocalStrings getName() {
        return this.string;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public static ChiselMode castMode(IToolMode chiselMode) {
        if (chiselMode instanceof ChiselMode) {
            return (ChiselMode)chiselMode;
        }
        return SINGLE;
    }
}

