/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.items;

import java.util.List;
import jotato.quantumflux.helpers.NbtHelpers;
import jotato.quantumflux.items.ItemBase;
import jotato.quantumflux.machines.telepad.BlockTelepad;
import jotato.quantumflux.machines.telepad.TileTelepad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemLinkingCard
extends ItemBase {
    private static final String DIMKEY = "linked_dimension";
    private static final String BLOCKPOS = "blockPOS";

    public ItemLinkingCard() {
        super("linkingCard");
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockTelepad) {
            if (NbtHelpers.keyExists(stack, BLOCKPOS)) {
                return this.linkTelepads(stack, playerIn, worldIn, pos);
            }
            return this.setLocation(stack, playerIn, worldIn, pos);
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult setLocation(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos) {
        NbtHelpers.setInt(stack, DIMKEY, playerIn.field_71093_bK);
        BlockPos linkedPostion = new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p());
        NbtHelpers.setLong(stack, BLOCKPOS, linkedPostion.func_177986_g());
        if (!worldIn.field_72995_K) {
            TextComponentTranslation msg = new TextComponentTranslation("chat.telepad.link.stored", new Object[0]);
            playerIn.func_145747_a((ITextComponent)msg);
        }
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult linkTelepads(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos) {
        if (NbtHelpers.keyExists(stack, BLOCKPOS)) {
            BlockPos storedPos = BlockPos.func_177969_a((long)NbtHelpers.getLong(stack, BLOCKPOS));
            int storedDimension = NbtHelpers.getInt(stack, DIMKEY);
            if (storedPos.equals((Object)pos)) {
                return EnumActionResult.PASS;
            }
            if (playerIn.field_71093_bK != storedDimension && !worldIn.field_72995_K) {
                TextComponentTranslation msg = new TextComponentTranslation("chat.telepad.link.error.1", new Object[0]);
                playerIn.func_145747_a((ITextComponent)msg);
            }
            if (worldIn.func_175625_s(storedPos) instanceof TileTelepad && worldIn.func_175625_s(pos) instanceof TileTelepad) {
                TileTelepad first = (TileTelepad)worldIn.func_175625_s(storedPos);
                TileTelepad second = (TileTelepad)worldIn.func_175625_s(pos);
                first.linkTelepad(pos, storedDimension);
                second.linkTelepad(storedPos, storedDimension);
                if (!worldIn.field_72995_K) {
                    TextComponentTranslation msg = new TextComponentTranslation("chat.telepad.link.success", new Object[0]);
                    playerIn.func_145747_a((ITextComponent)msg);
                }
                NbtHelpers.deleteKey(stack, DIMKEY);
                NbtHelpers.deleteKey(stack, BLOCKPOS);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (NbtHelpers.keyExists(stack, DIMKEY)) {
            BlockPos pos = BlockPos.func_177969_a((long)NbtHelpers.getLong(stack, BLOCKPOS));
            tooltip.add(String.format("%s", pos.toString()));
            tooltip.add(String.format("Dimension{%d}", NbtHelpers.getInt(stack, DIMKEY)));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            NbtHelpers.deleteKey(itemStackIn, DIMKEY);
            NbtHelpers.deleteKey(itemStackIn, BLOCKPOS);
            if (!worldIn.field_72995_K) {
                TextComponentTranslation msg = new TextComponentTranslation("chat.telepad.link.clear", new Object[0]);
                playerIn.func_145747_a((ITextComponent)msg);
            }
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }
}

