/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.entangler;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.UUID;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.redflux.IRedfluxProvider;
import jotato.quantumflux.redflux.RedfluxField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileRFEntangler
extends TileEntity
implements IEnergyReceiver,
IRedfluxProvider,
ITickable {
    public UUID owner;
    private long lastIn;
    private long lastOut;
    public long reportedIn;
    public long reportedOut;
    private EnergyStorage storage = new EnergyStorage(ConfigMan.redfluxField_buffer, Integer.MAX_VALUE);

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int taken = this.storage.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            if (!this.field_145850_b.field_72995_K) {
                this.lastIn += (long)taken;
            }
            this.func_70296_d();
        }
        return taken;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        if (this.owner == null) {
            return tag;
        }
        NBTTagCompound energyTag = new NBTTagCompound();
        this.storage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74778_a("owner", this.owner.toString());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        try {
            NBTTagCompound energyTag = tag.func_74775_l("Energy");
            this.storage.readFromNBT(energyTag);
            this.owner = UUID.fromString(tag.func_74779_i("owner"));
            this.registerWithField();
        }
        catch (Exception ex) {
            Logger.error("HEY YOU! An RF Entangler at %d, %d, %d has corrupt data. The owner needs to replace it", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        }
    }

    @Override
    public boolean canSend() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    public int requestEnergy(int energy, boolean simulate) {
        int given = this.storage.extractEnergy(energy, simulate);
        if (!simulate) {
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.lastOut += (long)given;
            }
        }
        return given;
    }

    @Override
    public int receiveEnergy(int energy, boolean simulate) {
        return energy;
    }

    public void deregisterWithField() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RedfluxField.removeLink(this);
        }
    }

    public void registerWithField() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RedfluxField.registerLink(this);
        }
    }

    @Override
    public String getOwner() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.toString();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.deregisterWithField();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.deregisterWithField();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.registerWithField();
    }

    public void func_73660_a() {
        this.reportedOut = this.lastOut;
        this.reportedIn = this.lastIn;
        this.lastIn = 0L;
        this.lastOut = 0L;
    }
}

