/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.api.internal;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.recubed.api.internal.PlayerCategoryData;

public final class Category {
    public final HashMap<String, PlayerCategoryData> playerData = new HashMap();
    public final String name;
    public boolean isFrozen = false;

    public Category(String name) {
        this.name = name;
    }

    public int getTotalValue() {
        int total = 0;
        for (String s : this.playerData.keySet()) {
            total += this.getTotalValueFromPlayerData(s);
        }
        return total;
    }

    public int getTotalValueFromPlayerData(String data) {
        if (this.playerData.containsKey(data)) {
            return this.playerData.get(data).getTotalValue();
        }
        return 0;
    }

    public void loadFromNBT(NBTTagCompound cmp) {
        if (cmp == null) {
            return;
        }
        Set names = cmp.func_150296_c();
        for (String name : names) {
            cmp.func_74781_a(name);
            if (name.equals("isFrozen") || !cmp.func_74764_b(name)) continue;
            NBTTagCompound cmp1 = cmp.func_74775_l(name);
            if (!this.playerData.containsKey(name)) {
                this.playerData.put(name, new PlayerCategoryData(name));
            }
            this.playerData.get(name).loadFromNBT(cmp1);
        }
        this.isFrozen = cmp.func_74767_n("isFrozen");
    }

    public void writeToNBT(NBTTagCompound cmp) {
        for (String s : this.playerData.keySet()) {
            NBTTagCompound cmp1 = new NBTTagCompound();
            this.playerData.get(s).writeToNBT(cmp1);
            cmp.func_74782_a(s, (NBTBase)cmp1);
        }
        cmp.func_74757_a("isFrozen", this.isFrozen);
    }
}

