/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.client.core.handler;

import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.ClientData;
import vazkii.recubed.api.internal.PlayerCategoryData;
import vazkii.recubed.client.core.handler.ClientCacheHandler;
import vazkii.recubed.client.gui.GuiMoveHUD;
import vazkii.recubed.client.renders.StatBarsRender;

public final class HUDHandler {
    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && HUDHandler.shouldRenderHUD()) {
            Point coords = HUDHandler.getCoords(event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), ClientCacheHandler.hudRelativeTo, ClientCacheHandler.hudPosX, ClientCacheHandler.hudPosY);
            String categoryName = ClientCacheHandler.hudCategory;
            Category category = ClientData.categories.get(categoryName);
            if (category != null) {
                String playerName = ClientCacheHandler.hudPlayer;
                if (playerName == null || playerName.isEmpty()) {
                    StatBarsRender render = StatBarsRender.fromCategory(category);
                    if (render != null) {
                        render.renderStatBars(coords.x, coords.y);
                    }
                } else {
                    PlayerCategoryData data = category.playerData.get(playerName);
                    StatBarsRender render = StatBarsRender.fromPlayerData(data, category);
                    if (render != null) {
                        render.renderStatBars(coords.x, coords.y);
                    }
                }
            }
        }
    }

    private static boolean shouldRenderHUD() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiMoveHUD) {
            return true;
        }
        return ClientCacheHandler.drawHud;
    }

    public static Point getCoords(int screenX, int screenY, int relativePos, int posX, int posY) {
        switch (relativePos) {
            case 0: {
                return new Point(screenX - posX, posY);
            }
            case 1: {
                return new Point(posX, posY);
            }
            case 2: {
                return new Point(posX, screenY - posY);
            }
        }
        return new Point(screenX - posX, screenY - posY);
    }
}

