/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.handler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigHandler {
    private static final String CATEGORY_SERVER = "server";
    private static final String CATEGORY_CLIENT = "client";
    public static Configuration config;
    public static int packetInterval;
    public static boolean useCogwheel;
    public static List<String> commandPlayers;

    public static void load(File file) {
        config = new Configuration(file);
        config.load();
        Property propPacketInterval = config.get(CATEGORY_SERVER, "packet_interval", packetInterval);
        propPacketInterval.setComment("The interval in which packets are sent to client, default is 40 ticks (2 secs)");
        packetInterval = propPacketInterval.getInt(packetInterval);
        Property propCommandPlayers = config.get(CATEGORY_SERVER, "command_players", "");
        propCommandPlayers.setComment("A comma separated list of players allowed to use comamnds. Leave empty for all OPs");
        String commandPlayersStr = propCommandPlayers.getString().trim();
        if (!commandPlayersStr.isEmpty()) {
            List<String> commandPlayers = Arrays.asList(commandPlayersStr.split(","));
            for (String s : commandPlayers) {
                ConfigHandler.commandPlayers.add(s.toLowerCase());
            }
        }
        Property propUseCogwheel = config.get(CATEGORY_CLIENT, "use_cogwheel", useCogwheel);
        propUseCogwheel.setComment("Set to true to use the cogwheel button in the inventory, false to register a keybind");
        useCogwheel = propUseCogwheel.getBoolean(useCogwheel);
        config.save();
    }

    static {
        packetInterval = 40;
        useCogwheel = true;
        commandPlayers = new ArrayList<String>();
    }
}

