/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.handler;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandGive;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.recubed.api.ReCubedAPI;
import vazkii.recubed.common.core.helper.MiscHelper;

public final class GeneralEventHandler {
    private static ItemStack stackFromState(IBlockState state) {
        return new ItemStack(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityTakeDamage(ArrowLooseEvent event) {
        float f = (float)event.getCharge() / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if (ReCubedAPI.validatePlayer(event.getEntityPlayer())) {
            ReCubedAPI.addValueToCategory("recubed.category.arrows_shot", event.getEntityPlayer().func_146103_bH().getName(), f >= 1.0f ? "recubed.misc.critical_shot" : "recubed.misc.shot", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (ReCubedAPI.validatePlayer(event.getPlayer()) && event.getState().func_177230_c() != null && Item.func_150898_a((Block)event.getState().func_177230_c()) != null) {
            ReCubedAPI.addValueToCategory("recubed.category.blocks_broken", event.getPlayer().func_146103_bH().getName(), Item.func_150898_a((Block)event.getState().func_177230_c()).func_77667_c(GeneralEventHandler.stackFromState(event.getState())) + ".name", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteracted(PlayerInteractEvent.EntityInteract event) {
        if (ReCubedAPI.validatePlayer(event.getEntityPlayer())) {
            ItemStack mainStack = event.getEntityPlayer().func_184614_ca();
            ItemStack offStack = event.getEntityPlayer().func_184592_cb();
            if (mainStack != null) {
                if (mainStack.func_77973_b() == Items.field_151133_ar && event.getTarget() instanceof EntityCow) {
                    ReCubedAPI.addValueToCategory("recubed.category.cows_milked", event.getEntityPlayer().func_146103_bH().getName(), "item.milk.name", 1);
                }
                if (mainStack.func_77973_b() == Items.field_151097_aZ && event.getTarget() instanceof IShearable && ((IShearable)event.getTarget()).isShearable(mainStack, (IBlockAccess)event.getTarget().field_70170_p, new BlockPos(event.getTarget()))) {
                    ReCubedAPI.addValueToCategory("recubed.category.animals_sheared", event.getEntityPlayer().func_146103_bH().getName(), MiscHelper.getEntityString(event.getTarget()), 1);
                }
                if (mainStack.func_77973_b() instanceof ItemDye && event.getTarget() instanceof EntitySheep && !((EntitySheep)event.getTarget()).func_70892_o() && 15 - ((EntitySheep)event.getTarget()).func_175509_cj().func_176767_b() != mainStack.func_77952_i()) {
                    ReCubedAPI.addValueToCategory("recubed.category.sheep_dyed", event.getEntityPlayer().func_146103_bH().getName(), MiscHelper.getStackName(mainStack), 1);
                }
            }
            if (offStack != null) {
                if (offStack.func_77973_b() == Items.field_151133_ar && event.getTarget() instanceof EntityCow) {
                    ReCubedAPI.addValueToCategory("recubed.category.cows_milked", event.getEntityPlayer().func_146103_bH().getName(), "item.milk.name", 1);
                }
                if (offStack.func_77973_b() == Items.field_151097_aZ && event.getTarget() instanceof IShearable && ((IShearable)event.getTarget()).isShearable(offStack, (IBlockAccess)event.getTarget().field_70170_p, new BlockPos(event.getTarget()))) {
                    ReCubedAPI.addValueToCategory("recubed.category.animals_sheared", event.getEntityPlayer().func_146103_bH().getName(), MiscHelper.getEntityString(event.getTarget()), 1);
                }
                if (offStack.func_77973_b() instanceof ItemDye && event.getTarget() instanceof EntitySheep && !((EntitySheep)event.getTarget()).func_70892_o() && 15 - ((EntitySheep)event.getTarget()).func_175509_cj().func_176767_b() != offStack.func_77952_i()) {
                    ReCubedAPI.addValueToCategory("recubed.category.sheep_dyed", event.getEntityPlayer().func_146103_bH().getName(), MiscHelper.getStackName(offStack), 1);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityTakeDamage(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            String name = MiscHelper.getEntityString(event.getEntity());
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory("recubed.category.damage_dealt", player.func_146103_bH().getName(), name, (int)Math.min(event.getEntityLiving().func_110143_aJ(), event.getAmount()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTakeDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            String name = "recubed.damage." + event.getSource().func_76355_l();
            if (event.getSource().func_76346_g() != null) {
                name = MiscHelper.getEntityString(event.getSource().func_76346_g());
            }
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory("recubed.category.damage_taken", player.func_146103_bH().getName(), name, (int)Math.min(player.func_110143_aJ(), event.getAmount()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemBroken(PlayerDestroyItemEvent event) {
        if (ReCubedAPI.validatePlayer(event.getEntityPlayer()) && event.getOriginal().func_77984_f() && event.getOriginal().func_77952_i() == event.getOriginal().func_77958_k()) {
            ReCubedAPI.addValueToCategory("recubed.category.items_broken", event.getEntityPlayer().func_146103_bH().getName(), MiscHelper.getStackName(event.getOriginal()), 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTossItem(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (ReCubedAPI.validatePlayer(event.getPlayer())) {
            ReCubedAPI.addValueToCategory("recubed.category.items_dropped", event.getPlayer().func_146103_bH().getName(), MiscHelper.getStackName(stack), stack.field_77994_a);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemPickedUp(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (ReCubedAPI.validatePlayer(event.getEntityPlayer())) {
            ReCubedAPI.addValueToCategory("recubed.category.items_picked_up", event.getEntityPlayer().func_146103_bH().getName(), MiscHelper.getStackName(stack), stack.field_77994_a);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMessageReceived(ServerChatEvent event) {
        if (ReCubedAPI.validatePlayer((EntityPlayer)event.getPlayer())) {
            ReCubedAPI.addValueToCategory("recubed.category.messages_sent", event.getUsername(), "recubed.misc.chat", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMessageReceived(CommandEvent event) {
        if (event.getSender() instanceof EntityPlayer && ReCubedAPI.validatePlayer((EntityPlayer)event.getSender())) {
            ReCubedAPI.addValueToCategory("recubed.category.messages_sent", event.getSender().func_70005_c_(), "/" + event.getCommand().func_71517_b(), 1);
            try {
                if (event.getCommand() instanceof CommandGive) {
                    String name = event.getParameters()[1];
                    Item item = CommandBase.func_147179_f((ICommandSender)event.getSender(), (String)name);
                    int j = 1;
                    int k = 0;
                    if (item == null) {
                        return;
                    }
                    if (event.getParameters().length >= 3) {
                        j = CommandBase.func_175764_a((String)event.getParameters()[2], (int)1, (int)64);
                    }
                    if (event.getParameters().length >= 4) {
                        k = CommandBase.func_175755_a((String)event.getParameters()[3]);
                    }
                    ItemStack stack = new ItemStack(item, j, k);
                    ReCubedAPI.addValueToCategory("recubed.category.items_spawned", event.getSender().func_70005_c_(), MiscHelper.getStackName(stack), 1);
                }
            }
            catch (NumberInvalidException numberInvalidException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMobGetTarget(LivingSetAttackTargetEvent event) {
        EntityPlayer player;
        if (event.getTarget() instanceof EntityPlayer && EntityList.func_75621_b((Entity)event.getEntity()) != null && ReCubedAPI.validatePlayer(player = (EntityPlayer)event.getTarget())) {
            ReCubedAPI.addValueToCategory("recubed.category.mobs_aggroed", player.func_146103_bH().getName(), MiscHelper.getEntityString(event.getEntity()), 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDie(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getEntity() instanceof EntityPlayer)) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            String name = MiscHelper.getEntityString(event.getEntity());
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory(event.getEntity().func_184222_aU() ? "recubed.category.mobs_killed" : "recubed.category.boss_kills", player.func_146103_bH().getName(), name, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDie(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            String name = "recubed.damage." + event.getSource().func_76355_l();
            if (event.getSource().func_76346_g() != null) {
                name = MiscHelper.getEntityString(event.getSource().func_76346_g());
            }
            if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                name = ((EntityPlayer)event.getSource().func_76346_g()).func_146103_bH().getName();
                if (ReCubedAPI.validatePlayer((EntityPlayer)event.getSource().func_76346_g())) {
                    ReCubedAPI.addValueToCategory("recubed.category.player_kills", name, player.func_146103_bH().getName(), 1);
                }
            }
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory("recubed.category.times_died", player.func_146103_bH().getName(), name, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteractItem(PlayerInteractEvent.RightClickItem event) {
        if (ReCubedAPI.validatePlayer(event.getEntityPlayer())) {
            List effects;
            ItemPotion potion;
            ItemStack mainStack = event.getEntityPlayer().func_184614_ca();
            ItemStack offStack = event.getEntityPlayer().func_184592_cb();
            if (mainStack != null) {
                if (mainStack.func_77973_b() == Items.field_151126_ay) {
                    ReCubedAPI.addValueToCategory("recubed.category.snowballs_thrown", event.getEntityPlayer().func_146103_bH().getName(), "item.snowball.name", 1);
                }
                if (!event.getEntityPlayer().field_71075_bZ.field_75098_d && mainStack.func_77973_b() == Items.field_151079_bi) {
                    ReCubedAPI.addValueToCategory("recubed.category.ender_pearls_thrown", event.getEntityPlayer().func_146103_bH().getName(), "item.enderPearl.name", 1);
                }
                if (event.getEntityPlayer().field_71093_bK == 0 && mainStack.func_77973_b() == Items.field_151061_bv) {
                    ReCubedAPI.addValueToCategory("recubed.category.ender_eyes_used", event.getEntityPlayer().func_146103_bH().getName(), "item.eyeOfEnder.name", 1);
                }
                if (mainStack.func_77973_b() == Items.field_151112_aM && event.getEntityPlayer().field_71104_cf == null) {
                    ReCubedAPI.addValueToCategory("recubed.category.times_fished", event.getEntityPlayer().func_146103_bH().getName(), "recubed.misc.hook_casted", 1);
                }
                if (mainStack.func_77973_b() == Items.field_151068_bn && (potion = (ItemPotion)mainStack.func_77973_b()) instanceof ItemSplashPotion && (effects = PotionUtils.func_185189_a((ItemStack)mainStack)) != null) {
                    for (PotionEffect effect : effects) {
                        ReCubedAPI.addValueToCategory("recubed.category.potions_thrown", event.getEntityPlayer().func_146103_bH().getName(), effect.func_188419_a().func_76393_a(), 1);
                    }
                }
            }
            if (offStack != null) {
                if (offStack.func_77973_b() == Items.field_151126_ay) {
                    ReCubedAPI.addValueToCategory("recubed.category.snowballs_thrown", event.getEntityPlayer().func_146103_bH().getName(), "item.snowball.name", 1);
                }
                if (!event.getEntityPlayer().field_71075_bZ.field_75098_d && offStack.func_77973_b() == Items.field_151079_bi) {
                    ReCubedAPI.addValueToCategory("recubed.category.ender_pearls_thrown", event.getEntityPlayer().func_146103_bH().getName(), "item.enderPearl.name", 1);
                }
                if (event.getEntityPlayer().field_71093_bK == 0 && offStack.func_77973_b() == Items.field_151061_bv) {
                    ReCubedAPI.addValueToCategory("recubed.category.ender_eyes_used", event.getEntityPlayer().func_146103_bH().getName(), "item.eyeOfEnder.name", 1);
                }
                if (offStack.func_77973_b() == Items.field_151112_aM && event.getEntityPlayer().field_71104_cf == null) {
                    ReCubedAPI.addValueToCategory("recubed.category.times_fished", event.getEntityPlayer().func_146103_bH().getName(), "recubed.misc.hook_casted", 1);
                }
                if (offStack.func_77973_b() == Items.field_151068_bn && (potion = (ItemPotion)offStack.func_77973_b()) instanceof ItemSplashPotion && (effects = PotionUtils.func_185189_a((ItemStack)offStack)) != null) {
                    for (PotionEffect effect : effects) {
                        ReCubedAPI.addValueToCategory("recubed.category.potions_thrown", event.getEntityPlayer().func_146103_bH().getName(), effect.func_188419_a().func_76393_a(), 1);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteractBlock(PlayerInteractEvent.RightClickItem event) {
        if (ReCubedAPI.validatePlayer(event.getEntityPlayer())) {
            ItemStack mainStack = event.getEntityPlayer().func_184614_ca();
            ItemStack offStack = event.getEntityPlayer().func_184592_cb();
            if (mainStack != null && mainStack.func_77973_b() instanceof ItemRecord && event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150421_aI) {
                ReCubedAPI.addValueToCategory("recubed.category.discs_played", event.getEntityPlayer().func_146103_bH().getName(), ((ItemRecord)mainStack.func_77973_b()).func_150927_i(), 1);
            }
            if (offStack != null && offStack.func_77973_b() instanceof ItemRecord && event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150421_aI) {
                ReCubedAPI.addValueToCategory("recubed.category.discs_played", event.getEntityPlayer().func_146103_bH().getName(), ((ItemRecord)offStack.func_77973_b()).func_150927_i(), 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (!ReCubedAPI.validatePlayer(event.getEntityPlayer())) {
            return;
        }
        EntityPlayer.SleepResult status = event.getResultStatus();
        if (status == null && !event.getEntityPlayer().field_70170_p.field_72995_K) {
            if (event.getEntityPlayer().func_70608_bn() || !event.getEntityPlayer().func_70089_S()) {
                status = EntityPlayer.SleepResult.OTHER_PROBLEM;
            } else if (!event.getEntityPlayer().field_70170_p.field_73011_w.func_76569_d()) {
                status = EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            } else if (event.getEntityPlayer().field_70170_p.func_72935_r()) {
                status = EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            } else if (Math.abs(event.getEntityPlayer().field_70165_t - (double)event.getPos().func_177958_n()) > 3.0 || Math.abs(event.getEntityPlayer().field_70163_u - (double)event.getPos().func_177956_o()) > 3.0 || Math.abs(event.getEntityPlayer().field_70161_v - (double)event.getPos().func_177952_p()) > 3.0) {
                status = EntityPlayer.SleepResult.TOO_FAR_AWAY;
            } else {
                double d0 = 8.0;
                double d1 = 5.0;
                List list = event.getEntityPlayer().field_70170_p.func_72872_a(EntityMob.class, new AxisAlignedBB((double)event.getPos().func_177958_n() - d0, (double)event.getPos().func_177956_o() - d1, (double)event.getPos().func_177952_p() - d0, (double)event.getPos().func_177958_n() + d0, (double)event.getPos().func_177956_o() + d1, (double)event.getPos().func_177952_p() + d0));
                status = !list.isEmpty() ? EntityPlayer.SleepResult.NOT_SAFE : EntityPlayer.SleepResult.OK;
            }
        }
        if (status == EntityPlayer.SleepResult.OK) {
            ReCubedAPI.addValueToCategory("recubed.category.times_slept", event.getEntityPlayer().func_146103_bH().getName(), "recubed.misc.sleep", 1);
        }
    }
}

