/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import vazkii.recubed.api.internal.ServerData;

public class CacheHelper {
    public static File getCacheFile() throws IOException {
        return CacheHelper.getCacheFile("", "ReCubed.dat", true);
    }

    public static File getCacheFile(String loc_, String name, boolean create) throws IOException {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = server.field_71305_c[0];
        File loc = world.getChunkSaveLocation();
        File cacheFile = new File(loc, loc_.isEmpty() ? name : loc_);
        if (!loc_.isEmpty()) {
            cacheFile.mkdirs();
            cacheFile = new File(cacheFile, name);
        }
        if (!cacheFile.exists()) {
            if (create) {
                cacheFile.createNewFile();
            } else {
                return null;
            }
        }
        return cacheFile;
    }

    public static NBTTagCompound getCacheCompound(File cache) {
        if (cache == null) {
            throw new RuntimeException("No cache file!");
        }
        try {
            NBTTagCompound cmp = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(cache));
            return cmp;
        }
        catch (IOException e) {
            NBTTagCompound cmp = new NBTTagCompound();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(cache));
                return CacheHelper.getCacheCompound(cache);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static void injectNBTToFile(NBTTagCompound cmp, File f) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void findCompoundAndLoad() {
        try {
            NBTTagCompound cmp = CacheHelper.getCacheCompound(CacheHelper.getCacheFile());
            ServerData.loadFromNBT(cmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void findCompoundAndWrite() {
        NBTTagCompound cmp = new NBTTagCompound();
        ServerData.writeToNBT(cmp);
        try {
            CacheHelper.injectNBTToFile(cmp, CacheHelper.getCacheFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

