/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.proxy;

import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import vazkii.recubed.api.ReCubedAPI;
import vazkii.recubed.api.internal.ServerData;
import vazkii.recubed.common.command.CommandCategoryFreeze;
import vazkii.recubed.common.command.CommandClearCategory;
import vazkii.recubed.common.command.CommandClearPlayer;
import vazkii.recubed.common.command.CommandDelBackup;
import vazkii.recubed.common.command.CommandFreeze;
import vazkii.recubed.common.command.CommandLoadBackup;
import vazkii.recubed.common.command.CommandSaveBackup;
import vazkii.recubed.common.command.CommandWipeData;
import vazkii.recubed.common.command.CommandWipePlayer;
import vazkii.recubed.common.core.handler.ConfigHandler;
import vazkii.recubed.common.core.handler.GeneralEventHandler;
import vazkii.recubed.common.core.handler.PlayerTracker;
import vazkii.recubed.common.core.handler.ServerTickHandler;
import vazkii.recubed.common.core.handler.WorldSaveHandler;
import vazkii.recubed.common.core.helper.CacheHelper;
import vazkii.recubed.common.network.PacketCategory;
import vazkii.recubed.common.network.PacketHandler;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.load(event.getSuggestedConfigurationFile());
        CommonProxy.registerCategory("recubed.category.animals_sheared");
        CommonProxy.registerCategory("recubed.category.arrows_shot");
        CommonProxy.registerCategory("recubed.category.boss_kills");
        CommonProxy.registerCategory("recubed.category.blocks_broken");
        CommonProxy.registerCategory("recubed.category.cows_milked");
        CommonProxy.registerCategory("recubed.category.damage_dealt");
        CommonProxy.registerCategory("recubed.category.damage_taken");
        CommonProxy.registerCategory("recubed.category.dimensions_changed");
        CommonProxy.registerCategory("recubed.category.discs_played");
        CommonProxy.registerCategory("recubed.category.ender_eyes_used");
        CommonProxy.registerCategory("recubed.category.ender_pearls_thrown");
        CommonProxy.registerCategory("recubed.category.entities_ridden");
        CommonProxy.registerCategory("recubed.category.experience_gathered");
        CommonProxy.registerCategory("recubed.category.items_broken");
        CommonProxy.registerCategory("recubed.category.items_dropped");
        CommonProxy.registerCategory("recubed.category.items_picked_up");
        CommonProxy.registerCategory("recubed.category.items_spawned");
        CommonProxy.registerCategory("recubed.category.levels_gained");
        CommonProxy.registerCategory("recubed.category.mobs_aggroed");
        CommonProxy.registerCategory("recubed.category.mobs_killed");
        CommonProxy.registerCategory("recubed.category.messages_sent");
        CommonProxy.registerCategory("recubed.category.player_kills");
        CommonProxy.registerCategory("recubed.category.potions_gotten");
        CommonProxy.registerCategory("recubed.category.potions_thrown");
        CommonProxy.registerCategory("recubed.category.sheep_dyed");
        CommonProxy.registerCategory("recubed.category.snowballs_thrown");
        CommonProxy.registerCategory("recubed.category.times_died");
        CommonProxy.registerCategory("recubed.category.times_fished");
        CommonProxy.registerCategory("recubed.category.times_played");
        CommonProxy.registerCategory("recubed.category.times_slept");
    }

    private static void registerCategory(String category) {
        ReCubedAPI.registerCategory(category, category.substring("recubed.category.".length()));
    }

    public void receivePacket(PacketCategory packet) {
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new WorldSaveHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GeneralEventHandler());
        PacketHandler.init();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        ServerData.init();
        event.registerServerCommand((ICommand)new CommandCategoryFreeze());
        event.registerServerCommand((ICommand)new CommandClearCategory());
        event.registerServerCommand((ICommand)new CommandClearPlayer());
        event.registerServerCommand((ICommand)new CommandDelBackup());
        event.registerServerCommand((ICommand)new CommandFreeze());
        event.registerServerCommand((ICommand)new CommandLoadBackup());
        event.registerServerCommand((ICommand)new CommandSaveBackup());
        event.registerServerCommand((ICommand)new CommandWipeData());
        event.registerServerCommand((ICommand)new CommandWipePlayer());
    }

    public void serverStarted() {
        CacheHelper.findCompoundAndLoad();
    }

    public void serverStopping() {
        CacheHelper.findCompoundAndWrite();
    }

    public void serverStopped() {
        ServerData.reset();
    }
}

