/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.ServerData;
import vazkii.recubed.common.ReCubed;

public class PacketCategory
implements IMessage,
IMessageHandler<PacketCategory, IMessage> {
    public Category category;
    public String name;

    public PacketCategory() {
    }

    public PacketCategory(Category category) {
        this.category = category;
        this.name = category.name;
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        NBTTagCompound cmp = new NBTTagCompound();
        this.category.writeToNBT(cmp);
        packet.func_180714_a(this.name);
        packet.func_150786_a(cmp);
    }

    public static Collection<PacketCategory> allCategoryPackets() {
        ArrayList<PacketCategory> packets = new ArrayList<PacketCategory>();
        for (String s : ServerData.categories.keySet()) {
            packets.add(new PacketCategory(ServerData.categories.get(s)));
        }
        return packets;
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        try {
            this.name = packet.func_150789_c(Short.MAX_VALUE);
            this.category = new Category(this.name);
            this.category.loadFromNBT(packet.func_150793_b());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IMessage onMessage(PacketCategory message, MessageContext context) {
        ReCubed.proxy.receivePacket(message);
        return null;
    }
}

