/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.impl.abstraction;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.TextHelper;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiHome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CategoryAbstract {
    public Map<ResourceLocation, EntryAbstract> entries = new HashMap<ResourceLocation, EntryAbstract>();
    public String unlocCategoryName;

    public CategoryAbstract(Map<ResourceLocation, EntryAbstract> entries, String unlocCategoryName) {
        this.entries = entries;
        this.unlocCategoryName = unlocCategoryName;
    }

    public void addEntry(ResourceLocation key, EntryAbstract entry) {
        this.entries.put(key, entry);
    }

    public void removeEntry(ResourceLocation key) {
        this.entries.remove(key);
    }

    public void addEntries(Map<ResourceLocation, EntryAbstract> entries) {
        this.entries.putAll(entries);
    }

    public void removeEntries(List<ResourceLocation> keys) {
        for (ResourceLocation key : keys) {
            if (!this.entries.containsKey(key)) continue;
            this.entries.remove(key);
        }
    }

    public String getLocalizedName() {
        return TextHelper.localizeEffect(this.unlocCategoryName, new Object[0]);
    }

    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getLocalizedName());
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(Book var1, int var2, int var3, int var4, int var5, int var6, int var7, GuiBase var8, boolean var9, RenderItem var10);

    @SideOnly(value=Side.CLIENT)
    public abstract void drawExtras(Book var1, int var2, int var3, int var4, int var5, int var6, int var7, GuiBase var8, boolean var9, RenderItem var10);

    public abstract boolean canSee(EntityPlayer var1, ItemStack var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void onLeftClicked(Book var1, int var2, int var3, EntityPlayer var4, ItemStack var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void onRightClicked(Book var1, int var2, int var3, EntityPlayer var4, ItemStack var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void onInit(Book var1, GuiHome var2, EntityPlayer var3, ItemStack var4);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryAbstract that = (CategoryAbstract)o;
        if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) {
            return false;
        }
        return !(this.unlocCategoryName != null ? !this.unlocCategoryName.equals(that.unlocCategoryName) : that.unlocCategoryName != null);
    }

    public int hashCode() {
        int result = this.entries != null ? this.entries.hashCode() : 0;
        result = 31 * result + (this.unlocCategoryName != null ? this.unlocCategoryName.hashCode() : 0);
        return result;
    }
}

