/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.button.ButtonNext;
import amerifrance.guideapi.button.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.network.PacketSyncHome;
import amerifrance.guideapi.wrapper.CategoryWrapper;
import com.google.common.collect.HashMultimap;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiHome
extends GuiBase {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public HashMultimap<Integer, CategoryWrapper> categoryWrapperMap = HashMultimap.create();
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public int categoryPage;

    public GuiHome(Book book, EntityPlayer player, ItemStack bookStack) {
        super(player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.categoryPage = 0;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.categoryWrapperMap.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonNext = new ButtonNext(0, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonNext);
        this.buttonPrev = new ButtonPrev(1, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonPrev);
        int cX = this.guiLeft + 45;
        int cY = this.guiTop + 40;
        int drawLoc = 0;
        int i = 0;
        int pageNumber = 0;
        for (CategoryAbstract category : this.book.getCategoryList()) {
            category.onInit(this.book, this, this.player, this.bookStack);
            switch (drawLoc) {
                case 0: {
                    this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX, cY, 23, 23, this.player, this.field_146289_q, this.field_146296_j, false, this.bookStack));
                    cX += 27;
                    drawLoc = 1;
                    break;
                }
                case 1: {
                    this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX, cY, 23, 23, this.player, this.field_146289_q, this.field_146296_j, false, this.bookStack));
                    cX += 27;
                    drawLoc = 2;
                    break;
                }
                case 2: {
                    this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX, cY, 23, 23, this.player, this.field_146289_q, this.field_146296_j, false, this.bookStack));
                    cX += 27;
                    drawLoc = 3;
                    break;
                }
                case 3: {
                    this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX, cY, 23, 23, this.player, this.field_146289_q, this.field_146296_j, false, this.bookStack));
                    drawLoc = 0;
                    cX = this.guiLeft + 45;
                    cY += 30;
                }
            }
            if (++i < 16) continue;
            i = 0;
            cX = this.guiLeft + 45;
            cY = this.guiTop + 40;
            ++pageNumber;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.pageTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        this.func_73732_a(this.field_146289_q, this.book.getLocalizedWelcomeMessage().replace("\\n", "\n").replace("&", "\u00a7"), this.guiLeft + this.xSize / 2 + 1, this.guiTop + 15, 0);
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.draw(mouseX, mouseY, this);
        }
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.drawExtras(mouseX, mouseY, this);
        }
        this.func_73732_a(this.field_146289_q, String.format("%d/%d", this.categoryPage + 1, this.categoryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        this.drawCenteredStringWithShadow(this.field_146289_q, this.book.getLocalizedBookTitle(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.field_146125_m = this.categoryPage != 0;
        this.buttonNext.field_146125_m = this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty();
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int typeofClick) {
        try {
            super.func_73864_a(mouseX, mouseY, typeofClick);
            for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    wrapper.category.onLeftClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                    continue;
                }
                if (typeofClick != 1) continue;
                wrapper.category.onRightClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void func_146274_d() {
        try {
            super.func_146274_d();
            int movement = Mouse.getEventDWheel();
            if (movement < 0) {
                this.nextPage();
            } else if (movement > 0) {
                this.prevPage();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        if ((keyCode == 200 || keyCode == 205) && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            this.nextPage();
        }
        if ((keyCode == 208 || keyCode == 203) && this.categoryPage > 0) {
            this.prevPage();
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            this.nextPage();
        } else if (button.field_146127_k == 1 && this.categoryPage > 0) {
            this.prevPage();
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncHome(this.categoryPage));
    }

    public void nextPage() {
        if (this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty()) {
            ++this.categoryPage;
        }
    }

    public void prevPage() {
        if (this.categoryPage != 0) {
            --this.categoryPage;
        }
    }
}

