/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.configuration.client;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.StringUtils;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.configuration.client.elements.GuiElementSlotItemlist;
import portablejim.veinminer.lib.IconRenderer;
import portablejim.veinminer.util.BlockID;

public class ItemlistConfigGuiScreen
extends GuiScreen {
    String toolType;
    int mode;
    IconRenderer iconRenderer;
    GuiButton addButton;
    GuiButton clearButton;
    GuiTextField textFieldAdd;
    String textFieldText = "";
    boolean renderIcon = false;
    String titleString;
    GuiElementSlotItemlist itemList;
    private Object parent;

    public ItemlistConfigGuiScreen(GuiScreen parent, String toolType, int mode) {
        this.toolType = toolType;
        this.mode = mode;
        this.parent = parent;
        String[] modeNames = new String[]{"blocklist", "toollist"};
        String modeName = modeNames[mode];
        this.titleString = String.format("gui.veinminer.title.%s", modeName);
    }

    public void func_73866_w_() {
        this.itemList = new GuiElementSlotItemlist(this, this.toolType);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - 34, 150, 20, I18n.func_135052_a((String)"gui.veinminer.back", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 152, this.field_146295_m - 34, 150, 20, I18n.func_135052_a((String)"gui.veinminer.item.delete", (Object[])new Object[0])));
        this.addButton = new GuiButton(3, this.field_146294_l / 2 + 52, 34, 48, 20, I18n.func_135052_a((String)"gui.veinminer.item.add", (Object[])new Object[0]));
        this.addButton.field_146124_l = false;
        this.field_146292_n.add(this.addButton);
        this.clearButton = new GuiButton(4, this.field_146294_l / 2 + 104, 34, 48, 20, I18n.func_135052_a((String)"gui.veinminer.item.clear", (Object[])new Object[0]));
        this.clearButton.field_146124_l = false;
        this.field_146292_n.add(this.clearButton);
        this.iconRenderer = new IconRenderer(this.field_146297_k, this.field_73735_i);
        this.textFieldAdd = new GuiTextField(5, this.getFontRenderer(), this.field_146294_l / 2 - 128, 34, 176, 20);
        this.textFieldAdd.func_146203_f(128);
        this.textFieldAdd.func_146184_c(true);
        this.textFieldAdd.func_146195_b(true);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public float getZLevel() {
        return this.field_73735_i;
    }

    public void addButtonCheck() {
        BlockID testBlockId = new BlockID(this.textFieldText);
        String[] testItemName = testBlockId.name.split(":", 2);
        if (testItemName.length == 2) {
            Block testBlock = Block.func_149684_b((String)testBlockId.name);
            Item testItem = GameRegistry.findItem((String)testItemName[0], (String)testItemName[1]);
            switch (this.mode) {
                case 0: {
                    this.addButton.field_146124_l = testBlock != null;
                    break;
                }
                case 1: {
                    this.addButton.field_146124_l = testBlock != null || testItem != null;
                }
            }
            this.renderIcon = testItem != null;
        } else {
            this.addButton.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            switch (par1GuiButton.field_146127_k) {
                case 1: {
                    FMLClientHandler.instance().showGuiScreen(this.parent);
                    break;
                }
                case 2: {
                    String selectedItem = this.itemList.items.get(this.itemList.selectedItem);
                    switch (this.mode) {
                        case 0: {
                            BlockID targetItem = new BlockID(selectedItem);
                            VeinMiner.instance.configurationSettings.removeBlockFromWhitelist(this.toolType, targetItem);
                            break;
                        }
                        case 1: {
                            VeinMiner.instance.configurationSettings.removeTool(this.toolType, selectedItem);
                        }
                    }
                    VeinMiner.instance.configurationSettings.saveConfigs();
                    break;
                }
                case 3: {
                    switch (this.mode) {
                        case 0: {
                            BlockID targetItem = new BlockID(this.textFieldText);
                            VeinMiner.instance.configurationSettings.addBlockToWhitelist(this.toolType, targetItem);
                            break;
                        }
                        case 1: {
                            VeinMiner.instance.configurationSettings.addTool(this.toolType, this.textFieldText);
                        }
                    }
                    VeinMiner.instance.configurationSettings.saveConfigs();
                    break;
                }
                case 4: {
                    this.textFieldAdd.func_146180_a("");
                    this.textFieldText = "";
                    this.addButtonCheck();
                }
            }
            this.itemList.updateItemIds();
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.textFieldAdd.func_146206_l()) {
            this.textFieldAdd.func_146201_a(par1, par2);
            this.textFieldText = this.textFieldAdd.func_146179_b();
            this.addButtonCheck();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        try {
            super.func_73864_a(par1, par2, par3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textFieldAdd.func_146192_a(par1, par2, par3);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.itemList.drawScreen(par1, par2, par3);
        this.func_73732_a(this.getFontRenderer(), I18n.func_135052_a((String)this.titleString, (Object[])new Object[]{StringUtils.capitalize((String)this.toolType)}), this.field_146294_l / 2, 14, 0xFFFFFF);
        this.clearButton.field_146124_l = !this.textFieldText.isEmpty();
        this.textFieldAdd.func_146194_f();
        super.func_73863_a(par1, par2, par3);
        if (this.renderIcon) {
            BlockID testBlockId = new BlockID(this.textFieldText);
            Item testItem = Item.func_111206_d((String)testBlockId.name);
            Block testBlock = Block.func_149684_b((String)testBlockId.name);
            ItemStack itemStack = null;
            if (testItem != null) {
                itemStack = new ItemStack(testItem);
            } else if (testBlock != null) {
                itemStack = new ItemStack(testBlock);
            }
            if (itemStack != null) {
                itemStack.func_77964_b(testBlockId.metadata == -1 ? 0 : testBlockId.metadata);
                this.iconRenderer.renderItemStackIcon(this.field_146294_l / 2 - 152, 34, itemStack);
            }
        }
    }

    public ArrayList<String> getList() {
        if (this.mode == 0) {
            return VeinMiner.instance.configurationSettings.getBlockIDArray(this.toolType);
        }
        if (this.mode == 1) {
            return VeinMiner.instance.configurationSettings.getToolIdArray(this.toolType);
        }
        return null;
    }
}

