/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import portablejim.veinminer.api.Permission;
import portablejim.veinminer.api.Point;
import portablejim.veinminer.api.VeinminerHarvestFailedCheck;
import portablejim.veinminer.api.VeinminerNoToolCheck;
import portablejim.veinminer.api.VeinminerPostUseTool;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.lib.BlockLib;
import portablejim.veinminer.lib.MinerLogger;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;
import portablejim.veinminer.util.ExpCalculator;
import portablejim.veinminer.util.ItemStackID;
import portablejim.veinminer.util.PlayerStatus;

public class MinerInstance {
    public MinerServer serverInstance;
    private HashSet<Point> startBlacklist = new HashSet();
    private ConcurrentLinkedQueue<Point> destroyQueue = new ConcurrentLinkedQueue();
    private HashSet<Point> awaitingEntityDrop = new HashSet();
    private LinkedHashMap<ItemStackID, Integer> drops = new LinkedHashMap();
    private World world;
    private EntityPlayerMP player;
    private BlockID targetBlock;
    private boolean finished;
    private ItemStack usedItem;
    private int numBlocksMined;
    private Point initalBlock;
    private int radiusLimit;
    private int blockLimit;
    private static final int MIN_HUNGER = 1;

    public MinerInstance(World world, EntityPlayerMP player, Point startPoint, BlockID blockID, MinerServer server, int radiusLimit, int blockLimit) {
        this.world = world;
        this.player = player;
        this.targetBlock = blockID;
        this.finished = false;
        this.serverInstance = server;
        this.usedItem = player.func_184614_ca();
        this.numBlocksMined = 1;
        this.initalBlock = startPoint;
        this.radiusLimit = radiusLimit;
        this.blockLimit = blockLimit;
        this.serverInstance.addInstance(this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public Point getInitalBlock() {
        return this.initalBlock;
    }

    public void cleanUp() {
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }

    private boolean shouldContinue() {
        int experienceMod;
        UUID playerName;
        PlayerStatus playerStatus;
        if (!this.serverInstance.getConfigurationSettings().getEnableAllTools() && this.player.func_184614_ca() == null) {
            VeinminerNoToolCheck toolCheck = new VeinminerNoToolCheck(this.player);
            MinecraftForge.EVENT_BUS.post((Event)toolCheck);
            if (toolCheck.allowTool.isAllowed()) {
                this.finished = false;
            } else if (toolCheck.allowTool == Permission.FORCE_DENY) {
                this.finished = true;
            } else {
                Block testBlock = Blocks.field_150348_b;
                PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck((EntityPlayer)this.player, testBlock.func_176223_P(), false);
                MinecraftForge.EVENT_BUS.post((Event)event);
                boolean bl = this.finished = !event.canHarvest();
            }
        }
        if (this.usedItem == null) {
            if (this.player.func_184614_ca() != null) {
                this.finished = true;
            }
        } else if (this.player.func_184614_ca() == null || !this.player.func_184614_ca().func_77969_a(this.usedItem)) {
            this.finished = true;
        }
        if ((playerStatus = this.serverInstance.getPlayerStatus(playerName = this.player.func_110124_au())) == null) {
            this.finished = true;
        } else if (playerStatus == PlayerStatus.INACTIVE || playerStatus == PlayerStatus.SNEAK_ACTIVE && !this.player.func_70093_af() || playerStatus == PlayerStatus.SNEAK_INACTIVE && this.player.func_70093_af()) {
            this.finished = true;
        }
        if (this.finished) {
            return false;
        }
        FoodStats food = this.player.func_71024_bL();
        if (food.func_75116_a() < 1) {
            this.finished = true;
            String problem = "mod.veinminer.finished.tooHungry";
            if (this.serverInstance.playerHasClient(this.player.func_110124_au())) {
                this.player.func_145747_a((ITextComponent)new TextComponentTranslation(problem, new Object[0]));
            } else {
                String translatedProblem = I18n.func_74838_a((String)problem);
                this.player.func_145747_a((ITextComponent)new TextComponentString(translatedProblem));
            }
        }
        if ((experienceMod = this.serverInstance.getConfigurationSettings().getExperienceMultiplier()) > 0 && ExpCalculator.getExp(this.player.field_71068_ca, this.player.field_71106_cc) < experienceMod) {
            this.finished = true;
            String problem = "mod.veinminer.finished.noExp";
            if (this.player.field_71106_cc < 0.0f) {
                this.player.field_71106_cc = 0.0f;
            }
            if (this.player.field_71106_cc > 1.0f) {
                this.player.field_71106_cc = 1.0f;
            }
            if (this.player.field_71068_ca < 0) {
                this.player.field_71068_ca = 0;
            }
            this.player.func_82242_a(0);
            if (this.serverInstance.playerHasClient(this.player.func_110124_au())) {
                this.player.func_145747_a((ITextComponent)new TextComponentTranslation(problem, new Object[0]));
            } else {
                String translatedProblem = I18n.func_74838_a((String)problem);
                this.player.func_145747_a((ITextComponent)new TextComponentString(translatedProblem));
            }
        }
        if (this.numBlocksMined >= this.blockLimit && this.blockLimit != -1) {
            MinerLogger.debug("Blocks mined: %d; Blocklimit: %d. Forcing finish.", this.numBlocksMined, this.blockLimit);
            this.finished = true;
        }
        return !this.finished;
    }

    private boolean toolAllowedForBlock(ItemStack tool, BlockID block) {
        boolean toolAllowed = false;
        ConfigurationSettings settings = this.serverInstance.getConfigurationSettings();
        for (String type : settings.getToolTypeNames()) {
            if (!settings.toolIsOfType(tool, type) || !this.serverInstance.getConfigurationSettings().whiteListHasBlockId(type, block)) continue;
            toolAllowed = true;
        }
        return toolAllowed;
    }

    private void takeHunger() {
        float hungerMod = (float)this.serverInstance.getConfigurationSettings().getHungerMultiplier() * 0.025f;
        FoodStats s = this.player.func_71024_bL();
        NBTTagCompound nbt = new NBTTagCompound();
        s.func_75117_b(nbt);
        int foodLevel = nbt.func_74762_e("foodLevel");
        int foodTimer = nbt.func_74762_e("foodTickTimer");
        float foodSaturationLevel = nbt.func_74760_g("foodSaturationLevel");
        float foodExhaustionLevel = nbt.func_74760_g("foodExhaustionLevel");
        float newExhaustion = (foodExhaustionLevel + hungerMod) % 4.0f;
        float newSaturation = foodSaturationLevel - (float)((int)((foodExhaustionLevel + hungerMod) / 4.0f));
        int newFoodLevel = foodLevel;
        if (newSaturation < 0.0f) {
            newFoodLevel = (int)((float)newFoodLevel + newSaturation);
            newSaturation = 0.0f;
        }
        nbt.func_74768_a("foodLevel", newFoodLevel);
        nbt.func_74768_a("foodTickTimer", foodTimer);
        nbt.func_74776_a("foodSaturationLevel", newSaturation);
        nbt.func_74776_a("foodExhaustionLevel", newExhaustion);
        s.func_75112_a(nbt);
    }

    private void takeExperience() {
        int targetLevel = this.player.field_71068_ca;
        int expToTakeAway = this.serverInstance.getConfigurationSettings().getExperienceMultiplier();
        if (expToTakeAway == 0) {
            return;
        }
        if ((float)expToTakeAway > this.player.field_71106_cc * (float)this.player.func_71050_bK()) {
            int newExp = ExpCalculator.getExp(this.player.field_71068_ca, this.player.field_71106_cc) - expToTakeAway;
            while (ExpCalculator.getExp(targetLevel, 0.0f) > newExp) {
                --targetLevel;
            }
            this.player.field_71068_ca = targetLevel < 0 ? 0 : targetLevel;
            int newExpTotal = newExp - ExpCalculator.getExp(targetLevel, 0.0f);
            this.player.field_71106_cc = Math.max(0.0f, Math.min(1.0f, (float)newExpTotal / (float)this.player.func_71050_bK()));
            this.player.field_71067_cb = Math.max(0, newExpTotal);
            if (newExp <= 0) {
                this.player.field_71106_cc = 0.0f;
                this.player.field_71068_ca = 0;
                this.player.field_71067_cb = 0;
            }
        } else {
            this.player.func_71023_q(-expToTakeAway);
        }
        this.player.func_82242_a(0);
    }

    public int mineBlock(Point point) {
        return this.mineBlock(point.getX(), point.getY(), point.getZ());
    }

    private int mineBlock(int x, int y, int z) {
        int mineSuccessful = 0;
        Point newPoint = new Point(x, y, z);
        BlockID newBlock = new BlockID(this.world, new BlockPos(x, y, z));
        ConfigurationSettings configurationSettings = this.serverInstance.getConfigurationSettings();
        this.startBlacklist.add(newPoint);
        if (this.mineAllowed(newBlock, newPoint, configurationSettings)) {
            mineSuccessful |= 1;
            this.awaitingEntityDrop.add(newPoint);
            boolean success = this.player.field_71134_c.func_180237_b(new BlockPos(x, y, z));
            ++this.numBlocksMined;
            if (!this.player.field_71075_bZ.field_75098_d) {
                this.takeHunger();
                this.takeExperience();
            }
            VeinminerPostUseTool toolUsedEvent = new VeinminerPostUseTool(this.player, newPoint);
            MinecraftForge.EVENT_BUS.post((Event)toolUsedEvent);
            VeinminerHarvestFailedCheck continueCheck = new VeinminerHarvestFailedCheck(this.player, newPoint, this.targetBlock.name, this.targetBlock.metadata);
            MinecraftForge.EVENT_BUS.post((Event)continueCheck);
            if (success || continueCheck.allowContinue.isAllowed()) {
                mineSuccessful |= 2;
                this.postSuccessfulBreak(newPoint);
                this.awaitingEntityDrop.remove(newPoint);
            } else {
                this.awaitingEntityDrop.remove(newPoint);
            }
        }
        return mineSuccessful;
    }

    public void postSuccessfulBreak(Point breakPoint) {
        ArrayList<Point> surrondingPoints = this.getPoints(breakPoint);
        this.destroyQueue.addAll(surrondingPoints);
    }

    private ArrayList<Point> getPoints(Point origin) {
        int[] dimRange;
        ArrayList<Point> points = new ArrayList<Point>(9);
        for (int dx : dimRange = new int[]{-1, 0, 1}) {
            for (int dy : dimRange) {
                for (int dz : dimRange) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    points.add(new Point(origin.getX() + dx, origin.getY() + dy, origin.getZ() + dz));
                }
            }
        }
        Collections.shuffle(points);
        return points;
    }

    private boolean mineAllowed(BlockID newBlock, Point newBlockPos, ConfigurationSettings configSettings) {
        if (this.finished || !this.shouldContinue()) {
            return false;
        }
        if (Block.func_149684_b((String)newBlock.name) == null) {
            return false;
        }
        if (!(newBlock.wildcardEquals(this.targetBlock) || configSettings.areBlocksCongruent(newBlock, this.targetBlock) || BlockLib.arePickBlockEqual(newBlock, this.targetBlock))) {
            return false;
        }
        if (!newBlockPos.isWithinRange(this.initalBlock, this.radiusLimit) && this.radiusLimit > 0) {
            MinerLogger.debug("Initial block: %d,%d,%d; New block: %d,%d,%d; Radius: %.2f; Raidus limit: %d.", this.initalBlock.getX(), this.initalBlock.getY(), this.initalBlock.getZ(), newBlockPos.getX(), newBlockPos.getY(), newBlockPos.getZ(), Math.sqrt(this.initalBlock.distanceFrom(newBlockPos)), this.radiusLimit);
            return false;
        }
        if (this.awaitingEntityDrop.contains(newBlockPos)) {
            return false;
        }
        if (this.numBlocksMined >= this.blockLimit && this.blockLimit != -1) {
            MinerLogger.debug("Block limit is: %d; Blocks mined: %d", this.blockLimit, this.numBlocksMined);
            return false;
        }
        boolean result = configSettings.getEnableAllBlocks() || this.toolAllowedForBlock(this.usedItem, newBlock);
        return result;
    }

    @SubscribeEvent
    public void mineScheduled(TickEvent.ServerTickEvent event) {
        int quantity = this.serverInstance.getConfigurationSettings().getBlocksPerTick();
        int i = 0;
        while (i < quantity) {
            if (!this.destroyQueue.isEmpty()) {
                Point target = (Point)this.destroyQueue.remove();
                if ((this.mineBlock(target.getX(), target.getY(), target.getZ()) & 2) != 2) continue;
                ++i;
                continue;
            }
            this.serverInstance.removeInstance(this);
            if (!this.drops.isEmpty()) {
                this.spawnDrops();
            }
            this.cleanUp();
            return;
        }
    }

    private void spawnDrops() {
        for (Map.Entry<ItemStackID, Integer> schedDrop : this.drops.entrySet()) {
            EntityItem newEntityItem;
            ItemStack newItemStack;
            int numItems;
            ItemStackID itemStack = schedDrop.getKey();
            String itemName = itemStack.getItemId();
            Item foundItem = Item.func_111206_d((String)itemName);
            if (foundItem == null) continue;
            int itemDamage = itemStack.getDamage();
            for (numItems = schedDrop.getValue().intValue(); numItems > itemStack.getMaxStackSize(); numItems -= itemStack.getMaxStackSize()) {
                newItemStack = new ItemStack(foundItem, itemStack.getMaxStackSize(), itemDamage);
                newEntityItem = new EntityItem(this.world, (double)this.initalBlock.getX(), (double)this.initalBlock.getY(), (double)this.initalBlock.getZ(), newItemStack);
                this.world.func_72838_d((Entity)newEntityItem);
            }
            newItemStack = new ItemStack(foundItem, numItems, itemDamage);
            newItemStack.func_77964_b(itemStack.getDamage());
            newEntityItem = new EntityItem(this.world, (double)this.initalBlock.getX(), (double)this.initalBlock.getY(), (double)this.initalBlock.getZ(), newItemStack);
            this.world.func_72838_d((Entity)newEntityItem);
        }
        this.drops.clear();
    }

    public boolean isRegistered(Point p) {
        return this.awaitingEntityDrop.contains(p);
    }

    public void addDrop(EntityItem entity) {
        ItemStack item = entity.func_92059_d();
        ItemStackID itemInfo = new ItemStackID(item.func_77973_b(), item.func_77952_i(), item.func_77976_d());
        if (this.drops.containsKey(itemInfo)) {
            int oldDropNumber = this.drops.get(itemInfo);
            int newDropNumber = oldDropNumber + item.field_77994_a;
            this.drops.put(itemInfo, newDropNumber);
        } else {
            this.drops.put(itemInfo, item.field_77994_a);
        }
    }

    public boolean pointIsBlacklisted(Point point) {
        return this.startBlacklist.contains(point);
    }

    public void removeFromBlacklist(Point point) {
        if (this.startBlacklist.contains(point)) {
            this.startBlacklist.remove(point);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinerInstance that = (MinerInstance)o;
        if (this.radiusLimit != that.radiusLimit) {
            return false;
        }
        if (this.blockLimit != that.blockLimit) {
            return false;
        }
        if (this.serverInstance != null ? !this.serverInstance.equals(that.serverInstance) : that.serverInstance != null) {
            return false;
        }
        if (this.world != null ? !this.world.equals(that.world) : that.world != null) {
            return false;
        }
        if (this.player != null ? !this.player.equals((Object)that.player) : that.player != null) {
            return false;
        }
        if (this.usedItem != null ? !this.usedItem.equals(that.usedItem) : that.usedItem != null) {
            return false;
        }
        return this.initalBlock != null ? this.initalBlock.equals(that.initalBlock) : that.initalBlock == null;
    }

    public int hashCode() {
        int result = this.serverInstance != null ? this.serverInstance.hashCode() : 0;
        result = 31 * result + (this.world != null ? this.world.hashCode() : 0);
        result = 31 * result + (this.player != null ? this.player.hashCode() : 0);
        result = 31 * result + (this.usedItem != null ? this.usedItem.hashCode() : 0);
        result = 31 * result + (this.initalBlock != null ? this.initalBlock.hashCode() : 0);
        result = 31 * result + this.radiusLimit;
        result = 31 * result + this.blockLimit;
        return result;
    }
}

