/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.server;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.server.CommandSenderPlayer;
import portablejim.veinminer.server.CommandSenderServer;
import portablejim.veinminer.server.ICustomCommandSender;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;
import portablejim.veinminer.util.PlayerStatus;

public class MinerCommand
extends CommandBase {
    private MinerServer minerServer = null;
    public static final int COMMAND_MODE = 0;
    public static final int COMMAND_BLOCKLIST = 1;
    public static final int COMMAND_TOOLLIST = 2;
    public static final int COMMAND_BLOCKLIMIT = 3;
    public static final int COMMAND_RANGE = 4;
    public static final int COMMAND_PER_TICK = 5;
    public static final int COMMAND_SAVE = 6;
    public static final int COMMAND_RELOAD = 7;
    public static final int COMMAND_HELP = 8;
    private static final String[] commands = new String[]{"mode", "blocklist", "toollist", "blocklimit", "radius", "per_tick", "saveconfig", "reloadconfig", "help"};
    private static final String[] modes = new String[]{"auto", "sneak", "no_sneak"};

    public MinerCommand(MinerServer minerServerInstance) {
        this.minerServer = minerServerInstance;
    }

    public String func_71517_b() {
        return "veinminer";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender icommandsender, String[] astring) throws CommandException {
        ICustomCommandSender senderPlayer;
        if (icommandsender instanceof EntityPlayerMP) {
            senderPlayer = new CommandSenderPlayer(this.minerServer, (EntityPlayerMP)icommandsender);
        } else if (icommandsender instanceof DedicatedServer) {
            senderPlayer = new CommandSenderServer((DedicatedServer)icommandsender);
        } else {
            String message = I18n.func_74838_a((String)"command.veinminer.cannotuse");
            throw new CommandException(message, new Object[0]);
        }
        if (astring.length > 0) {
            if (astring[0].equals(commands[0])) {
                this.runCommandMode(senderPlayer, astring);
            } else if (astring[0].equals(commands[1])) {
                this.needAdmin(senderPlayer);
                this.runCommandBlocklist(senderPlayer, astring);
            } else if (astring[0].equals(commands[2])) {
                this.needAdmin(senderPlayer);
                this.runCommandToollist(senderPlayer, astring);
            } else if (astring[0].equals(commands[3])) {
                this.needAdmin(senderPlayer);
                this.runCommandBlocklimit(senderPlayer, astring);
            } else if (astring[0].equals(commands[4])) {
                this.needAdmin(senderPlayer);
                this.runCommandRange(senderPlayer, astring);
            } else if (astring[0].equals(commands[5])) {
                this.needAdmin(senderPlayer);
                this.runCommandPerTick(senderPlayer, astring);
            } else if (astring[0].equals(commands[6])) {
                this.needAdmin(senderPlayer);
                this.runCommandSave(senderPlayer);
            } else if (astring[0].equals(commands[7])) {
                this.needAdmin(senderPlayer);
                this.runCommandReload(senderPlayer);
            } else if (astring[0].equals(commands[8])) {
                this.runCommandHelp(senderPlayer, astring);
            } else {
                this.showUsageError("command.veinminer");
            }
        } else {
            this.showUsageError("command.veinminer");
        }
    }

    private void sendProperChatToPlayer(ICommandSender player, String incomingMessage, Object ... params) {
        TextComponentTranslation message;
        if (this.minerServer.playerHasClient(player.func_174793_f().getPersistentID())) {
            message = new TextComponentTranslation(incomingMessage, params);
        } else {
            String rawMessage = I18n.func_74838_a((String)incomingMessage);
            message = new TextComponentString(String.format(rawMessage, params));
        }
        player.func_145747_a((ITextComponent)message);
    }

    private void showUsageError(String errorKey) throws WrongUsageException {
        String message = I18n.func_74838_a((String)errorKey);
        throw new WrongUsageException(message, new Object[0]);
    }

    private void showUsageError(String errorKey, Object ... params) throws WrongUsageException {
        String message = I18n.func_74837_a((String)errorKey, (Object[])params);
        throw new WrongUsageException(message, new Object[0]);
    }

    private void needAdmin(ICustomCommandSender sender) throws CommandException {
        if (sender instanceof CommandSenderPlayer) {
            CommandSenderPlayer player = (CommandSenderPlayer)sender;
            MinecraftServer server = player.getPlayer().field_71133_b;
            if (server.func_71262_S() && !player.getPlayer().func_70003_b(server.func_110455_j(), "veinminer.admin")) {
                boolean playerNoClient = !this.minerServer.playerHasClient(player.getPlayer().func_110124_au());
                String message = "command.veinminer.permissionDenied";
                if (playerNoClient) {
                    message = I18n.func_150826_b((String)message);
                }
                throw new CommandException(message, new Object[0]);
            }
        }
    }

    private void commandAction(String[] commandString, String commandName) throws WrongUsageException {
        if (commandString.length < 3 || !"add".equals(commandString[2]) && !"remove".equals(commandString[2])) {
            this.showUsageError("command.veinminer." + commandName + ".actionerror", commandString[1]);
        }
    }

    private void runCommandMode(ICustomCommandSender sender, String[] astring) throws CommandException {
        if (sender instanceof CommandSenderPlayer) {
            CommandSenderPlayer senderPlayer = (CommandSenderPlayer)sender;
            UUID player = senderPlayer.getPlayer().getPersistentID();
            if (astring.length == 1) {
                this.showUsageError("command.veinminer.enable");
            } else if (this.minerServer.playerHasClient(player)) {
                this.showUsageError("command.veinminer.hasclient");
            } else if (astring[1].equals(modes[0])) {
                this.minerServer.setPlayerStatus(player, PlayerStatus.INACTIVE);
                senderPlayer.sendProperChat("command.veinminer.set.auto", new Object[0]);
            } else if (astring[1].equals(modes[1])) {
                this.minerServer.setPlayerStatus(player, PlayerStatus.SNEAK_ACTIVE);
                senderPlayer.sendProperChat("command.veinminer.set.sneak", new Object[0]);
            } else if (astring[1].equals(modes[2])) {
                this.minerServer.setPlayerStatus(player, PlayerStatus.SNEAK_INACTIVE);
                senderPlayer.sendProperChat("command.veinminer.set.nosneak", new Object[0]);
            }
        } else if (sender instanceof CommandSenderServer) {
            String message = sender.localise("command.veinminer.permissionDenied");
            throw new CommandException(message, new Object[0]);
        }
    }

    private void runCommandBlocklist(ICustomCommandSender senderPlayer, String[] astring) throws WrongUsageException {
        ConfigurationSettings configSettings = this.minerServer.getConfigurationSettings();
        ConfigurationSettings settings = this.minerServer.getConfigurationSettings();
        Set<String> toolsSet = settings.getToolTypeNames();
        String toolsSlashed = Joiner.on((String)"/").join(toolsSet);
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.blocklist", toolsSlashed);
        }
        if (!toolsSet.contains(astring[1])) {
            this.showUsageError("command.veinminer.blocklist", toolsSlashed);
            return;
        }
        String tool = astring[1];
        String toolString = settings.getToolTypeName(tool);
        this.commandAction(astring, "blockList");
        String action = astring[2];
        if (astring.length < 4) {
            this.showUsageError("command.veinminer.blocklist.itemerror", toolString, action);
        }
        int metadata = -1;
        if (astring.length >= 5) {
            try {
                metadata = Integer.parseInt(astring[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        BlockID blockID = new BlockID(astring[3], metadata);
        if (blockID.name.isEmpty()) {
            this.showUsageError("command.veinminer.blocklist.itemerror", toolString, action);
        }
        if ("add".equals(action)) {
            configSettings.addBlockToWhitelist(tool, blockID);
            senderPlayer.sendProperChat("command.veinminer.blocklist.add", blockID.name, blockID.metadata, toolString);
        } else if ("remove".equals(action)) {
            configSettings.removeBlockFromWhitelist(tool, blockID);
            senderPlayer.sendProperChat("command.veinminer.blocklist.remove", blockID.name, blockID.metadata, toolString);
        }
    }

    private void runCommandToollist(ICustomCommandSender senderPlayer, String[] astring) throws WrongUsageException {
        String toolId;
        ConfigurationSettings configSettings = this.minerServer.getConfigurationSettings();
        ConfigurationSettings settings = this.minerServer.getConfigurationSettings();
        Set<String> toolsSet = settings.getToolTypeNames();
        String toolsSlashed = Joiner.on((String)"/").join(toolsSet);
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.toollist", toolsSlashed);
        }
        if (!toolsSet.contains(astring[1])) {
            this.showUsageError("command.veinminer.toollist", toolsSlashed);
            return;
        }
        String tool = astring[1];
        String toolString = settings.getToolTypeName(tool);
        this.commandAction(astring, "toollist");
        String action = astring[2];
        if (astring.length < 4) {
            this.showUsageError("command.veinminer.toollist.itemerror", toolString, action);
        }
        if ((toolId = astring[3]).isEmpty()) {
            this.showUsageError("command.veinminer.toollist.itemerror", toolString, action);
        }
        if ("add".equals(action)) {
            configSettings.addTool(tool, toolId);
            senderPlayer.sendProperChat("command.veinminer.toollist.add", toolId, toolString);
        } else if ("remove".equals(action)) {
            configSettings.removeTool(tool, toolId);
            senderPlayer.sendProperChat("command.veinminer.toollist.remove", toolId, toolString);
        }
    }

    private void runCommandBlocklimit(ICustomCommandSender senderPlayer, String[] astring) throws WrongUsageException {
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.blocklimit");
        }
        int newBlockPerTick = 0;
        try {
            newBlockPerTick = Integer.parseInt(astring[1]);
        }
        catch (NumberFormatException e) {
            this.showUsageError("command.veinminer.blocklimit");
        }
        this.minerServer.getConfigurationSettings().setBlockLimit(newBlockPerTick);
        int actualBlockPerTick = this.minerServer.getConfigurationSettings().getBlockLimit();
        senderPlayer.sendProperChat("command.veinminer.blocklimit.set", actualBlockPerTick);
    }

    private void runCommandRange(ICustomCommandSender senderPlayer, String[] astring) throws WrongUsageException {
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.range");
        }
        int newRange = 0;
        try {
            newRange = Integer.parseInt(astring[1]);
        }
        catch (NumberFormatException e) {
            this.showUsageError("command.veinminer.range");
        }
        this.minerServer.getConfigurationSettings().setRadiusLimit(newRange);
        int actualRange = this.minerServer.getConfigurationSettings().getRadiusLimit();
        senderPlayer.sendProperChat("command.veinminer.range.set", actualRange);
    }

    private void runCommandPerTick(ICustomCommandSender senderPlayer, String[] astring) throws WrongUsageException {
        if (astring.length == 1) {
            this.showUsageError("command.veinminer.pertick");
        }
        int newRate = 0;
        try {
            newRate = Integer.parseInt(astring[1]);
        }
        catch (NumberFormatException e) {
            this.showUsageError("command.veinminer.pertick");
        }
        this.minerServer.getConfigurationSettings().setBlocksPerTick(newRate);
        int actualRate = this.minerServer.getConfigurationSettings().getBlocksPerTick();
        senderPlayer.sendProperChat("command.veinminer.pertick.set", actualRate);
    }

    private void runCommandSave(ICustomCommandSender senderPlayer) {
        this.minerServer.getConfigurationSettings().saveConfigs();
        senderPlayer.sendProperChat("command.veinminer.saveconfig", new Object[0]);
    }

    private void runCommandReload(ICustomCommandSender senderPlayer) {
        this.minerServer.getConfigurationSettings().reloadConfigFile();
        senderPlayer.sendProperChat("command.veinminer.loadconfig", new Object[0]);
    }

    private void runCommandHelp(ICustomCommandSender senderPlayer, String[] astring) {
        if (astring.length > 1) {
            if (astring[1].equals(commands[0])) {
                senderPlayer.sendProperChat("command.veinminer.help.enable1", new Object[0]);
                senderPlayer.sendProperChat("command.veinminer.help.enable2", new Object[0]);
                senderPlayer.sendProperChat("command.veinminer.help.enable3", new Object[0]);
                senderPlayer.sendProperChat("command.veinminer.help.enable4", new Object[0]);
            }
        } else {
            senderPlayer.sendProperChat("command.veinminer.help1", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help2", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help3", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help4", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help5", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help6", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help7", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help8", new Object[0]);
            senderPlayer.sendProperChat("command.veinminer.help9", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender par1ICommandSender, String[] arguments, BlockPos pos) {
        switch (arguments.length) {
            case 1: {
                return MinerCommand.func_71530_a((String[])arguments, (String[])commands);
            }
            case 2: {
                if (arguments[0].equals(commands[0])) {
                    return MinerCommand.func_71530_a((String[])arguments, (String[])modes);
                }
                if (arguments[0].equals(commands[1]) || arguments[0].equals(commands[2])) {
                    Set<String> toolsSet = this.minerServer.getConfigurationSettings().getToolTypeNames();
                    Object[] tools = new String[]{};
                    tools = toolsSet.toArray(tools);
                    Arrays.sort(tools);
                    return MinerCommand.func_71530_a((String[])arguments, (String[])tools);
                }
                if (arguments[0].equals(commands[2])) {
                    return MinerCommand.func_71530_a((String[])arguments, (String[])commands);
                }
            }
            case 3: {
                if (!arguments[0].equals(commands[1]) && !arguments[0].equals(commands[2])) break;
                String[] actions = new String[]{"add", "remove"};
                return MinerCommand.func_71530_a((String[])arguments, (String[])actions);
            }
        }
        return null;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return I18n.func_74838_a((String)"command.veinminer");
    }

    public int compareTo(MinerCommand par1ICommand) {
        return this.func_71517_b().compareTo(par1ICommand.func_71517_b());
    }
}

