/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import portablejim.veinminer.api.Point;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.core.MinerInstance;
import portablejim.veinminer.util.PlayerStatus;

public class MinerServer {
    private final Set<MinerInstance> minerInstances = Collections.synchronizedSet(new HashSet());
    private ConcurrentHashMap<Point, MinerInstance> pointMinerInstances = new ConcurrentHashMap();
    private HashSet<UUID> clientPlayers = new HashSet();
    private ConcurrentHashMap<UUID, PlayerStatus> players = new ConcurrentHashMap();
    private ConfigurationSettings settings;

    public MinerServer(ConfigurationValues configValues) {
        this.settings = new ConfigurationSettings(configValues);
    }

    public void setPlayerStatus(UUID player, PlayerStatus status) {
        this.players.put(player, status);
    }

    public PlayerStatus getPlayerStatus(UUID player) {
        if (this.players.containsKey(player)) {
            return this.players.get(player);
        }
        return PlayerStatus.INACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(Entity entity) {
        int eX = (int)Math.floor(entity.field_70165_t);
        int eY = (int)Math.floor(entity.field_70163_u);
        int eZ = (int)Math.floor(entity.field_70161_v);
        Point p = new Point(eX, eY, eZ);
        if (!EntityItem.class.isInstance(entity)) {
            return;
        }
        EntityItem entityItem = (EntityItem)entity;
        Set<MinerInstance> set = this.minerInstances;
        synchronized (set) {
            for (MinerInstance minerInstance : this.minerInstances) {
                if (!minerInstance.isRegistered(p)) continue;
                minerInstance.addDrop(entityItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitingDrop(Point p) {
        Set<MinerInstance> set = this.minerInstances;
        synchronized (set) {
            for (MinerInstance minerInstance : this.minerInstances) {
                if (!minerInstance.isRegistered(p)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointIsBlacklisted(Point point) {
        Set<MinerInstance> set = this.minerInstances;
        synchronized (set) {
            for (MinerInstance minerInstance : this.minerInstances) {
                if (!minerInstance.pointIsBlacklisted(point)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromBlacklist(Point point) {
        Set<MinerInstance> set = this.minerInstances;
        synchronized (set) {
            for (MinerInstance minerInstance : this.minerInstances) {
                if (!minerInstance.pointIsBlacklisted(point)) continue;
                minerInstance.removeFromBlacklist(point);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstance(MinerInstance ins) {
        Set<MinerInstance> set = this.minerInstances;
        synchronized (set) {
            this.minerInstances.add(ins);
        }
        this.pointMinerInstances.put(ins.getInitalBlock(), ins);
    }

    public MinerInstance getInstance(Point point) {
        if (this.pointMinerInstances.containsKey(point)) {
            return this.pointMinerInstances.get(point);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(MinerInstance ins) {
        Set<MinerInstance> set = this.minerInstances;
        synchronized (set) {
            this.minerInstances.remove(ins);
        }
        if (this.pointMinerInstances.containsKey(ins.getInitalBlock())) {
            this.pointMinerInstances.remove(ins);
        }
    }

    public ConfigurationSettings getConfigurationSettings() {
        return this.settings;
    }

    public boolean playerHasClient(UUID playerName) {
        return this.clientPlayers.contains(playerName);
    }

    public void addClientPlayer(UUID playerName) {
        this.clientPlayers.add(playerName);
        this.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
    }

    public void removeClientPlayer(UUID playerName) {
        this.clientPlayers.remove(playerName);
    }
}

