/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockID
implements Comparable<BlockID> {
    public String name;
    public int metadata;
    public IBlockState state = null;

    public BlockID(String fullDescription) {
        int preMeta = -1;
        Pattern p = Pattern.compile("([^/]+)(?:/([-]?\\d{1,2}))?");
        Matcher m = p.matcher(fullDescription);
        if (m.matches()) {
            this.name = m.group(1);
            if (m.group(2) != null) {
                try {
                    preMeta = Integer.parseInt(m.group(2));
                }
                catch (NumberFormatException e) {
                    preMeta = -1;
                }
            }
        } else {
            this.name = "";
        }
        this.metadata = preMeta >= -1 ? preMeta : -1;
    }

    public BlockID(String name, int meta) {
        this.name = name;
        this.metadata = meta < -1 || meta == Short.MAX_VALUE ? -1 : meta;
    }

    public BlockID(World world, BlockPos position) {
        this(world.func_180495_p(position));
    }

    public BlockID(IBlockState state) {
        this(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString(), state.func_177230_c().func_176201_c(state));
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockID)) {
            return false;
        }
        BlockID o = (BlockID)obj;
        return this.name.equals(o.name) && this.metadata == o.metadata;
    }

    public boolean wildcardEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockID)) {
            return false;
        }
        BlockID o = (BlockID)obj;
        if (o.metadata == -1 || this.metadata == -1) {
            return this.equals(obj);
        }
        return this.name.equals(o.name) && this.metadata == o.metadata;
    }

    public int hashCode() {
        return (this.name.hashCode() << 6) + this.metadata;
    }

    public String toString() {
        return this.metadata == -1 ? this.name + "" : this.name + "/" + this.metadata;
    }

    @Override
    public int compareTo(BlockID blockID) {
        if (this.name != null && !this.name.equals(blockID.name)) {
            int result = this.name.compareTo(blockID.name);
            if (result > 0) {
                return 1;
            }
            if (result < 0) {
                return -1;
            }
            return 0;
        }
        if (this.metadata < blockID.metadata) {
            return -1;
        }
        if (this.metadata > blockID.metadata) {
            return 1;
        }
        return 0;
    }
}

