/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminermodsupport;

import bluedart.api.IBreakable;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import portablejim.veinminer.api.IMCMessage;
import portablejim.veinminer.api.Permission;
import portablejim.veinminer.api.VeinminerHarvestFailedCheck;
import portablejim.veinminer.api.VeinminerPostUseTool;

@Mod(modid="VeinMinerModSupport", name="VeinMiner Mod Support", acceptedMinecraftVersions="[1.9,1.11)")
public class VeinMinerModSupport {
    private boolean debugMode = false;
    @Mod.Instance(value="VeinMinerModSupport")
    public static VeinMinerModSupport instance;
    public boolean forceConsumerAvailable;
    private Boolean configLoaded = false;
    private static final String[] FALSETOOLS_DEFAULT;
    private Set<String> falseTools = new LinkedHashSet<String>();
    private static final String[] OVERRIDE_BLACKLIST_DEFAULT;
    private Set<String> overrideBlacklist = new LinkedHashSet<String>();
    private static final String CONFIG_AUTODETECT = "autodetect";
    private static final String CONFIG_AUTODETECT_COMMENT = "Autodetect items and blocks during game start-up.";
    private boolean AUTODETECT_TOOLS_TOGGLE;
    private static final boolean AUTODETECT_TOOLS_TOGGLE_DEFAULT = true;
    private static final String AUTODETECT_TOOLS_TOGGLE_CONFIGNAME = "autodetect.tools";
    private static final String AUTODETECT_TOOLS_TOGGLE_DESCRIPTION = "Autodetect tools on starting the game, adding the names to the list.";

    @NetworkCheckHandler
    public boolean checkClientModVersion(Map<String, String> mods, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "veinminer");
        File loadedFile = new File(configDir, "modSupport.cfg");
        try {
            Configuration config = new Configuration(loadedFile);
            config.load();
            config.addCustomCategoryComment(CONFIG_AUTODETECT, CONFIG_AUTODETECT_COMMENT);
            this.AUTODETECT_TOOLS_TOGGLE = config.get(CONFIG_AUTODETECT, AUTODETECT_TOOLS_TOGGLE_CONFIGNAME, true, AUTODETECT_TOOLS_TOGGLE_DESCRIPTION).getBoolean(true);
            config.setCategoryComment("advanced", "You probably don't want to touch these");
            String[] falseTools_array = config.getStringList("special_snowflake_tools", "advanced", FALSETOOLS_DEFAULT, "Tools that need to be treated as special snowflakes\n");
            String[] overrideBlacklist_array = config.getStringList("override_blacklist_blocks", "advanced", OVERRIDE_BLACKLIST_DEFAULT, "Blocks to not override success for\n");
            this.falseTools = new LinkedHashSet<String>(Arrays.asList(falseTools_array));
            this.overrideBlacklist = new LinkedHashSet<String>(Arrays.asList(overrideBlacklist_array));
            config.save();
            this.configLoaded = true;
        }
        catch (Exception e) {
            event.getModLog().error("Error writing config file");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String fileName;
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModContainer thisMod = (ModContainer)Loader.instance().getIndexedModList().get("VeinMinerModSupport");
        if (thisMod != null && ((fileName = thisMod.getSource().getName()).contains("-dev") || !fileName.contains(".jar"))) {
            this.debugMode = true;
            this.devLog("DEV VERSION");
        }
        this.forceConsumerAvailable = false;
        if (this.AUTODETECT_TOOLS_TOGGLE) {
            this.addTools();
        }
    }

    private void addTools() {
        if (Loader.isModLoaded((String)"IC2")) {
            IMCMessage.addTool("axe", "IC2:itemToolBronzeAxe");
            IMCMessage.addTool("axe", "IC2:itemToolChainsaw");
            IMCMessage.addTool("hoe", "IC2:itemToolBronzeHoe");
            IMCMessage.addTool("pickaxe", "IC2:itemToolBronzePickaxe");
            IMCMessage.addTool("pickaxe", "IC2:itemToolDrill");
            IMCMessage.addTool("pickaxe", "IC2:itemToolDDrill");
            IMCMessage.addTool("pickaxe", "IC2:itemToolIridiumDrill");
            IMCMessage.addTool("shears", "IC2:itemToolBronzeHoe");
            IMCMessage.addTool("shovel", "IC2:itemToolBronzeSpade");
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            IMCMessage.addTool("axe", "appliedenergistics2:item.ToolCertusQuartzAxe");
            IMCMessage.addTool("hoe", "appliedenergistics2:item.ToolCertusQuartzHoe");
            IMCMessage.addTool("pickaxe", "appliedenergistics2:item.ToolCertusQuartzPickaxe");
            IMCMessage.addTool("shovel", "appliedenergistics2:item.ToolCertusQuartzSpade");
            IMCMessage.addTool("axe", "appliedenergistics2:item.ToolNetherQuartzAxe");
            IMCMessage.addTool("hoe", "appliedenergistics2:item.ToolNetherQuartzHoe");
            IMCMessage.addTool("pickaxe", "appliedenergistics2:item.ToolNetherQuartzPickaxe");
            IMCMessage.addTool("shovel", "appliedenergistics2:item.ToolNetherQuartzSpade");
        }
        if (Loader.isModLoaded((String)"BiomesOPlenty")) {
            IMCMessage.addTool("axe", "BiomesOPlenty:axeMud");
            IMCMessage.addTool("hoe", "BiomesOPlenty:hoeMud");
            IMCMessage.addTool("pickaxe", "BiomesOPlenty:pickaxeMud");
            IMCMessage.addTool("shovel", "BiomesOPlenty:shovelMud");
            IMCMessage.addTool("axe", "BiomesOPlenty:axeAmethyst");
            IMCMessage.addTool("hoe", "BiomesOPlenty:hoeAmethyst");
            IMCMessage.addTool("pickaxe", "BiomesOPlenty:pickaxeAmethyst");
            IMCMessage.addTool("shovel", "BiomesOPlenty:shovelAmethyst");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheWood");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheStone");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheIron");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheGold");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheDiamond");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheMud");
            IMCMessage.addTool("shears", "BiomesOPlenty:scytheAmethyst");
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            this.devLog("Tinkers support loaded");
            IMCMessage.addTool("axe", "tconstruct:hatchet");
            IMCMessage.addTool("hoe", "tconstruct:mattock");
            IMCMessage.addTool("pickaxe", "tconstruct:pickaxe");
            IMCMessage.addTool("shovel", "tconstruct:shovel");
            IMCMessage.addTool("shovel", "tconstruct:mattock");
        }
        if (Loader.isModLoaded((String)"exnihilo")) {
            this.devLog("Ex Nihilo support loaded");
            IMCMessage.addToolType("crook", "Crook", "exnihilo:crook");
            IMCMessage.addTool("crook", "exnihilo:crook");
            IMCMessage.addTool("crook", "exnihilo:crook_bone");
            IMCMessage.addToolType("hammer", "Hammer", "exnihilo:hammer_stone");
            IMCMessage.addTool("hammer", "exnihilo:hammer_wood");
            IMCMessage.addTool("hammer", "exnihilo:hammer_stone");
            IMCMessage.addTool("hammer", "exnihilo:hammer_iron");
            IMCMessage.addTool("hammer", "exnihilo:hammer_gold");
            IMCMessage.addTool("hammer", "exnihilo:hammer_diamond");
            IMCMessage.addBlock("crook", "minecraft:leaves");
            IMCMessage.addBlock("crook", "minecraft:leaves2");
            IMCMessage.addBlock("crook", "minecraft:tallgrass");
            IMCMessage.addBlock("crook", "minecraft:vine");
            IMCMessage.addBlock("crook", "minecraft:web");
            IMCMessage.addBlock("crook", "minecraft:wool");
            IMCMessage.addBlock("hammer", "exnihilo:aluminum_dust");
            IMCMessage.addBlock("hammer", "exnihilo:aluminum_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:aluminum_sand");
            IMCMessage.addBlock("hammer", "exnihilo:copper_dust");
            IMCMessage.addBlock("hammer", "exnihilo:copper_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:copper_sand");
            IMCMessage.addBlock("hammer", "exnihilo:dust");
            IMCMessage.addBlock("hammer", "exnihilo:ender_lead_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:ender_platinum_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:ender_silver_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:ender_tin_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:exnihilo.gravel_ender");
            IMCMessage.addBlock("hammer", "exnihilo:exnihilo.gravel_nether");
            IMCMessage.addBlock("hammer", "exnihilo:gold_dust");
            IMCMessage.addBlock("hammer", "exnihilo:gold_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:gold_sand");
            IMCMessage.addBlock("hammer", "exnihilo:iron_dust");
            IMCMessage.addBlock("hammer", "exnihilo:iron_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:iron_sand");
            IMCMessage.addBlock("hammer", "exnihilo:lead_dust");
            IMCMessage.addBlock("hammer", "exnihilo:lead_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:lead_sand");
            IMCMessage.addBlock("hammer", "exnihilo:nether_copper_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nether_gold_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nether_iron_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nether_nickel_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nickel_dust");
            IMCMessage.addBlock("hammer", "exnihilo:nickel_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:nickel_sand");
            IMCMessage.addBlock("hammer", "exnihilo:platinum_dust");
            IMCMessage.addBlock("hammer", "exnihilo:platinum_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:platinum_sand");
            IMCMessage.addBlock("hammer", "exnihilo:silver_dust");
            IMCMessage.addBlock("hammer", "exnihilo:silver_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:silver_sand");
            IMCMessage.addBlock("hammer", "exnihilo:tin_dust");
            IMCMessage.addBlock("hammer", "exnihilo:tin_gravel");
            IMCMessage.addBlock("hammer", "exnihilo:tin_sand");
            IMCMessage.addBlock("hammer", "minecraft:cobblestone");
            IMCMessage.addBlock("hammer", "minecraft:gravel");
            IMCMessage.addBlock("hammer", "minecraft:sand");
        }
        if (Loader.isModLoaded((String)"excompressum")) {
            IMCMessage.addToolType("hammer", "Hammer", "excompressum:chickenStick");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Testing for dartcraft classes and functions.");
            try {
                Method obj = Class.forName("bluedart.api.IForceConsumer").getMethod("attemptRepair", ItemStack.class);
                this.forceConsumerAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.devLog("Failed to find Dartcraft force consumer. Disabling repair support");
            }
            catch (NoSuchMethodException e) {
                this.devLog("Failed to find Dartcraft force consumer function. Disabling repair support");
            }
        }
    }

    private void devLog(String string) {
        if (this.debugMode) {
            FMLLog.getLogger().info("[VeinMinerModSupport] " + string);
        }
    }

    @SubscribeEvent
    public void makeToolsWork(VeinminerHarvestFailedCheck event) {
        String item_name;
        ItemStack currentEquipped = event.player.func_184614_ca();
        if (currentEquipped == null) {
            return;
        }
        if (event.allowContinue == Permission.DENY) {
            if (this.overrideBlacklist.contains(event.blockName)) {
                this.devLog("Denied with block: " + event.blockName);
                event.allowContinue = Permission.FORCE_DENY;
            } else {
                this.devLog("Not Denied with block: " + event.blockName);
            }
        }
        Item currentEquippedItem = event.player.func_184614_ca().func_77973_b();
        if (Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Dartcraft detected");
            if (currentEquippedItem instanceof IBreakable && event.allowContinue == Permission.DENY) {
                this.devLog("Allowed start");
                event.allowContinue = Permission.ALLOW;
            }
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            this.devLog("Tinkers Construct detected");
            this.tinkersConstructToolEvent(event);
        }
        if (event.allowContinue == Permission.DENY && this.falseTools.contains(item_name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)currentEquippedItem)).toString())) {
            this.devLog("Allowed start with " + item_name);
            event.allowContinue = Permission.ALLOW;
        }
        if (Loader.isModLoaded((String)"exnihilo")) {
            Class<?> hammerBase;
            this.devLog("Ex Nihilo detected");
            if (currentEquippedItem != null) {
                if (currentEquippedItem.getClass().getCanonicalName().startsWith("exnihilo.items.hammers") && event.allowContinue == Permission.DENY) {
                    this.devLog("Allowed hammer start");
                    event.allowContinue = Permission.ALLOW;
                } else {
                    this.devLog(currentEquippedItem.getClass().getCanonicalName());
                }
                Block testLeaves = Block.func_149684_b((String)event.blockName);
                if (Block.func_149684_b((String)event.blockName).isLeaves(testLeaves.func_176203_a(event.blockMetadata), (IBlockAccess)event.player.func_130014_f_(), event.player.func_180425_c()) && event.allowContinue == Permission.DENY) {
                    String item_name2 = currentEquippedItem.getRegistryName().toString();
                    if ("exnihilo:crook".equals(item_name2)) {
                        event.allowContinue = Permission.ALLOW;
                    }
                    if ("exnihilo:crook_bone".equals(item_name2)) {
                        event.allowContinue = Permission.ALLOW;
                    }
                    if ("exastris:crook_rf".equals(item_name2)) {
                        event.allowContinue = Permission.ALLOW;
                    }
                }
            }
            try {
                hammerBase = Class.forName("exnihilo.items.hammers.ItemHammerBase");
                if (currentEquippedItem != null && hammerBase.isAssignableFrom(currentEquippedItem.getClass()) && event.allowContinue == Permission.DENY) {
                    this.devLog("Allowed generic Ex Nihilo hammer start");
                    event.allowContinue = Permission.ALLOW;
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Ex Nihilo generic hammer support failed.");
            }
            try {
                hammerBase = Class.forName("ExAstris.Item.ItemHammerRF");
                if (currentEquippedItem != null && hammerBase.isAssignableFrom(currentEquippedItem.getClass()) && event.allowContinue == Permission.DENY) {
                    this.devLog("Allowed Ex Astris hammer start");
                    event.allowContinue = Permission.ALLOW;
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Ex Astris hammer support failed.");
            }
        }
    }

    private void tinkersConstructToolEvent(VeinminerHarvestFailedCheck event) {
        ItemStack currentItem = event.player.func_184614_ca();
        if (currentItem == null) {
            this.devLog("ERROR: Item is null");
            return;
        }
        if (!currentItem.func_77942_o()) {
            this.devLog("ERROR: No NBT data");
            return;
        }
        NBTTagCompound toolTags = currentItem.func_77978_p().func_74775_l("Stats");
        if (toolTags == null || toolTags.func_82582_d()) {
            this.devLog("ERROR: Not Tinkers Construct Tool");
            return;
        }
        Block block = Block.func_149684_b((String)event.blockName);
        if (block == null) {
            this.devLog("ERROR: Block id wrong.");
            return;
        }
        this.devLog("Allowing event");
        if (event.allowContinue == Permission.DENY) {
            event.allowContinue = Permission.ALLOW;
        }
    }

    @SubscribeEvent
    public void fixFalseNegatives(VeinminerHarvestFailedCheck event) {
        if (event.allowContinue == Permission.DENY && "IC2:blockRubWood".equals(event.blockName)) {
            event.allowContinue = Permission.ALLOW;
        }
    }

    @SubscribeEvent
    public void applyForce(VeinminerPostUseTool event) {
        ItemStack currentEquippedItemStack = event.player.func_184614_ca();
        if (this.forceConsumerAvailable && currentEquippedItemStack != null && Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Reflecting on Dartcraft run repair method.");
            try {
                Class<?> IForceConsumer = Class.forName("bluedart.api.IForceConsumer");
                if (IForceConsumer != null && IForceConsumer.isInstance(currentEquippedItemStack.func_77973_b())) {
                    Method attemptRepair = IForceConsumer.getMethod("attemptRepair", ItemStack.class);
                    attemptRepair.invoke((Object)currentEquippedItemStack.func_77973_b(), currentEquippedItemStack);
                    this.devLog("Repairing dartcraft force consumer");
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Strange, I thought we already found the Dartcraft class.");
                this.forceConsumerAvailable = false;
            }
            catch (NoSuchMethodException e) {
                this.devLog("Strange, I thought we already found the Dartcraft class and correct method.");
                this.forceConsumerAvailable = false;
            }
            catch (InvocationTargetException e) {
                this.devLog("Trying to repair Dartcraft tools didn't work. It threw a InvocationTargetException.");
                this.forceConsumerAvailable = false;
            }
            catch (IllegalAccessException e) {
                this.devLog("Trying to repair Dartcraft tools didn't work. It threw a IllegalAccessException.");
                this.forceConsumerAvailable = false;
            }
        }
    }

    static {
        FALSETOOLS_DEFAULT = new String[]{"excompressum:chickenStick", "excompressum:compressedHammerWood", "excompressum:compressedHammerStone", "excompressum:compressedHammerIron", "excompressum:compressedHammerGold", "excompressum:compressedHammerDiamond", "excompressum:doubleCompressedDiamondHammer", "excompressum:compressedCrook"};
        OVERRIDE_BLACKLIST_DEFAULT = new String[]{"EnderIO:blockConduitBundle"};
    }
}

