/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.Rotatable;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractModuleRotatable
extends AbstractModule
implements Rotatable {
    private Port facing = Port.UP;
    private static final String TAG_FACING = "facing";

    protected AbstractModuleRotatable(Casing casing, Face face) {
        super(casing, face);
    }

    @SideOnly(value=Side.CLIENT)
    protected void rotateForRendering() {
        int rotation = Port.ROTATION[this.facing.ordinal()];
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)(90 * rotation), (float)0.0f, (float)0.0f, (float)Face.toEnumFacing(this.getFace()).func_96559_d());
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
    }

    @Override
    protected Vec3d hitToUV(Vec3d hitPos) {
        Vec3d uv = super.hitToUV(hitPos);
        switch (this.getFace()) {
            case Y_NEG: {
                switch (this.getFacing()) {
                    case LEFT: {
                        return new Vec3d(uv.field_72448_b, 1.0 - uv.field_72450_a, 0.0);
                    }
                    case RIGHT: {
                        return new Vec3d(1.0 - uv.field_72448_b, uv.field_72450_a, 0.0);
                    }
                    case UP: {
                        return uv;
                    }
                    case DOWN: {
                        return new Vec3d(1.0 - uv.field_72450_a, 1.0 - uv.field_72448_b, 0.0);
                    }
                }
                break;
            }
            case Y_POS: {
                switch (this.getFacing()) {
                    case LEFT: {
                        return new Vec3d(1.0 - uv.field_72448_b, uv.field_72450_a, 0.0);
                    }
                    case RIGHT: {
                        return new Vec3d(uv.field_72448_b, 1.0 - uv.field_72450_a, 0.0);
                    }
                    case UP: {
                        return uv;
                    }
                    case DOWN: {
                        return new Vec3d(1.0 - uv.field_72450_a, 1.0 - uv.field_72448_b, 0.0);
                    }
                }
            }
        }
        return uv;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.facing = EnumUtils.readFromNBT(Port.class, TAG_FACING, nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        EnumUtils.writeToNBT(this.facing, TAG_FACING, nbt);
    }

    @Override
    public Port getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(Port facing) {
        this.facing = facing;
    }
}

