/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client;

import java.util.function.Supplier;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.prefab.manual.ItemStackTabIconRenderer;
import li.cil.tis3d.api.prefab.manual.TextureTabIconRenderer;
import li.cil.tis3d.client.gui.GuiHandlerClient;
import li.cil.tis3d.client.manual.provider.BlockImageProvider;
import li.cil.tis3d.client.manual.provider.ItemImageProvider;
import li.cil.tis3d.client.manual.provider.OreDictImageProvider;
import li.cil.tis3d.client.manual.provider.TextureImageProvider;
import li.cil.tis3d.client.model.obj.OBJLoader;
import li.cil.tis3d.client.render.TextureLoader;
import li.cil.tis3d.client.render.tile.TileEntitySpecialRendererCasing;
import li.cil.tis3d.common.ProxyCommon;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public final class ProxyClient
extends ProxyCommon {
    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        super.onPreInit(event);
        OBJLoader.INSTANCE.addDomain("tis3d".toLowerCase());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)OBJLoader.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TextureLoader.INSTANCE);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCasing.class, (TileEntitySpecialRenderer)new TileEntitySpecialRendererCasing());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)TIS3D.instance, (IGuiHandler)new GuiHandlerClient());
        ManualAPI.addProvider("", new TextureImageProvider());
        ManualAPI.addProvider("item", new ItemImageProvider());
        ManualAPI.addProvider("block", new BlockImageProvider());
        ManualAPI.addProvider("oredict", new OreDictImageProvider());
        ManualAPI.addTab(new TextureTabIconRenderer(new ResourceLocation("tis3d", "textures/gui/manualHome.png")), "tis3d.manual.home", "%LANGUAGE%/index.md");
        ManualAPI.addTab(new ItemStackTabIconRenderer(new ItemStack(Blocks.controller)), "tis3d.manual.blocks", "%LANGUAGE%/block/index.md");
        ManualAPI.addTab(new ItemStackTabIconRenderer(new ItemStack(Items.modules.get("moduleExecution"))), "tis3d.manual.items", "%LANGUAGE%/item/index.md");
        ManualAPI.addTab(new TextureTabIconRenderer(new ResourceLocation("tis3d", "textures/gui/manualSerialProtocols.png")), "tis3d.manual.serialProtocols", "%LANGUAGE%/serialProtocols.md");
    }

    @Override
    public Block registerBlock(String name, Supplier<Block> constructor, Class<? extends TileEntity> tileEntity) {
        Block block = super.registerBlock(name, constructor, tileEntity);
        ProxyClient.setCustomBlockModelResourceLocation(name, block);
        return block;
    }

    @Override
    public Item registerItem(String name, Supplier<Item> constructor) {
        Item item = super.registerItem(name, constructor);
        ProxyClient.setCustomItemModelResourceLocation(name, item);
        return item;
    }

    private static void setCustomBlockModelResourceLocation(String name, Block block) {
        Item item = Item.func_150898_a((Block)block);
        String path = "tis3d".toLowerCase() + ":" + name;
        ModelResourceLocation location = new ModelResourceLocation(path, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
    }

    private static void setCustomItemModelResourceLocation(String name, Item item) {
        String path = "tis3d".toLowerCase() + ":" + name;
        ModelResourceLocation location = new ModelResourceLocation(path, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
    }
}

